/*
 * Decompiled with CFR 0.152.
 */
package com.airbnb.lottie.parser;

import android.graphics.PointF;
import android.util.JsonReader;
import android.util.JsonToken;
import android.util.Log;
import com.airbnb.lottie.LottieComposition;
import com.airbnb.lottie.model.animatable.AnimatableFloatValue;
import com.airbnb.lottie.model.animatable.AnimatableIntegerValue;
import com.airbnb.lottie.model.animatable.AnimatablePathValue;
import com.airbnb.lottie.model.animatable.AnimatableScaleValue;
import com.airbnb.lottie.model.animatable.AnimatableTransform;
import com.airbnb.lottie.model.animatable.AnimatableValue;
import com.airbnb.lottie.parser.AnimatablePathValueParser;
import com.airbnb.lottie.parser.AnimatableValueParser;
import com.airbnb.lottie.value.ScaleXY;
import java.io.IOException;

public class AnimatableTransformParser {
    private AnimatableTransformParser() {
    }

    public static AnimatableTransform parse(JsonReader reader, LottieComposition composition) throws IOException {
        boolean isObject;
        AnimatablePathValue anchorPoint = null;
        AnimatableValue<PointF, PointF> position = null;
        AnimatableScaleValue scale = null;
        AnimatableFloatValue rotation = null;
        AnimatableIntegerValue opacity = null;
        AnimatableFloatValue startOpacity = null;
        AnimatableFloatValue endOpacity = null;
        boolean bl = isObject = reader.peek() == JsonToken.BEGIN_OBJECT;
        if (isObject) {
            reader.beginObject();
        }
        block20: while (reader.hasNext()) {
            switch (reader.nextName()) {
                case "a": {
                    reader.beginObject();
                    while (reader.hasNext()) {
                        if (reader.nextName().equals("k")) {
                            anchorPoint = AnimatablePathValueParser.parse(reader, composition);
                            continue;
                        }
                        reader.skipValue();
                    }
                    reader.endObject();
                    continue block20;
                }
                case "p": {
                    position = AnimatablePathValueParser.parseSplitPath(reader, composition);
                    continue block20;
                }
                case "s": {
                    scale = AnimatableValueParser.parseScale(reader, composition);
                    continue block20;
                }
                case "rz": {
                    composition.addWarning("Lottie doesn't support 3D layers.");
                }
                case "r": {
                    rotation = AnimatableValueParser.parseFloat(reader, composition, false);
                    continue block20;
                }
                case "o": {
                    opacity = AnimatableValueParser.parseInteger(reader, composition);
                    continue block20;
                }
                case "so": {
                    startOpacity = AnimatableValueParser.parseFloat(reader, composition, false);
                    continue block20;
                }
                case "eo": {
                    endOpacity = AnimatableValueParser.parseFloat(reader, composition, false);
                    continue block20;
                }
            }
            reader.skipValue();
        }
        if (isObject) {
            reader.endObject();
        }
        if (anchorPoint == null) {
            Log.w((String)"LOTTIE", (String)"Layer has no transform property. You may be using an unsupported layer type such as a camera.");
            anchorPoint = new AnimatablePathValue();
        }
        if (scale == null) {
            scale = new AnimatableScaleValue(new ScaleXY(1.0f, 1.0f));
        }
        if (opacity == null) {
            opacity = new AnimatableIntegerValue();
        }
        return new AnimatableTransform(anchorPoint, position, scale, rotation, opacity, startOpacity, endOpacity);
    }
}

