/*
 * Decompiled with CFR 0.152.
 */
package com.airbnb.lottie.parser;

import android.util.JsonReader;
import com.airbnb.lottie.LottieComposition;
import com.airbnb.lottie.model.animatable.AnimatableColorValue;
import com.airbnb.lottie.model.animatable.AnimatableFloatValue;
import com.airbnb.lottie.model.animatable.AnimatableTextProperties;
import com.airbnb.lottie.parser.AnimatableValueParser;
import java.io.IOException;

public class AnimatableTextPropertiesParser {
    private AnimatableTextPropertiesParser() {
    }

    public static AnimatableTextProperties parse(JsonReader reader, LottieComposition composition) throws IOException {
        AnimatableTextProperties anim = null;
        reader.beginObject();
        block6: while (reader.hasNext()) {
            switch (reader.nextName()) {
                case "a": {
                    anim = AnimatableTextPropertiesParser.parseAnimatableTextProperties(reader, composition);
                    continue block6;
                }
            }
            reader.skipValue();
        }
        reader.endObject();
        if (anim == null) {
            return new AnimatableTextProperties(null, null, null, null);
        }
        return anim;
    }

    private static AnimatableTextProperties parseAnimatableTextProperties(JsonReader reader, LottieComposition composition) throws IOException {
        AnimatableColorValue color = null;
        AnimatableColorValue stroke = null;
        AnimatableFloatValue strokeWidth = null;
        AnimatableFloatValue tracking = null;
        reader.beginObject();
        block12: while (reader.hasNext()) {
            switch (reader.nextName()) {
                case "fc": {
                    color = AnimatableValueParser.parseColor(reader, composition);
                    continue block12;
                }
                case "sc": {
                    stroke = AnimatableValueParser.parseColor(reader, composition);
                    continue block12;
                }
                case "sw": {
                    strokeWidth = AnimatableValueParser.parseFloat(reader, composition);
                    continue block12;
                }
                case "t": {
                    tracking = AnimatableValueParser.parseFloat(reader, composition);
                    continue block12;
                }
            }
            reader.skipValue();
        }
        reader.endObject();
        return new AnimatableTextProperties(color, stroke, strokeWidth, tracking);
    }
}

