/*
 * Decompiled with CFR 0.152.
 */
package com.airbnb.lottie.model;

import android.support.annotation.Nullable;
import android.support.annotation.RawRes;
import android.support.annotation.RestrictTo;
import android.support.annotation.VisibleForTesting;
import android.support.v4.util.LruCache;
import com.airbnb.lottie.LottieComposition;

@RestrictTo(value={RestrictTo.Scope.LIBRARY})
public class LottieCompositionCache {
    private static final int CACHE_SIZE_MB = 10;
    private static final LottieCompositionCache INSTANCE = new LottieCompositionCache();
    private final LruCache<String, LottieComposition> cache = new LruCache(0xA00000);

    public static LottieCompositionCache getInstance() {
        return INSTANCE;
    }

    @VisibleForTesting
    LottieCompositionCache() {
    }

    @Nullable
    public LottieComposition getRawRes(@RawRes int rawRes) {
        return this.get(Integer.toString(rawRes));
    }

    @Nullable
    public LottieComposition get(String assetName) {
        return (LottieComposition)this.cache.get((Object)assetName);
    }

    public void put(@RawRes int rawRes, @Nullable LottieComposition composition) {
        this.put(Integer.toString(rawRes), composition);
    }

    public void put(@Nullable String cacheKey, @Nullable LottieComposition composition) {
        if (cacheKey == null) {
            return;
        }
        this.cache.put((Object)cacheKey, (Object)composition);
    }
}

