/*
 * Decompiled with CFR 0.152.
 */
package com.airbnb.lottie.parser;

import android.graphics.PointF;
import android.util.JsonReader;
import com.airbnb.lottie.LottieComposition;
import com.airbnb.lottie.model.animatable.AnimatableFloatValue;
import com.airbnb.lottie.model.animatable.AnimatableValue;
import com.airbnb.lottie.model.content.PolystarShape;
import com.airbnb.lottie.parser.AnimatablePathValueParser;
import com.airbnb.lottie.parser.AnimatableValueParser;
import java.io.IOException;

class PolystarShapeParser {
    private PolystarShapeParser() {
    }

    static PolystarShape parse(JsonReader reader, LottieComposition composition) throws IOException {
        String name = null;
        PolystarShape.Type type = null;
        AnimatableFloatValue points = null;
        AnimatableValue<PointF, PointF> position = null;
        AnimatableFloatValue rotation = null;
        AnimatableFloatValue outerRadius = null;
        AnimatableFloatValue outerRoundedness = null;
        AnimatableFloatValue innerRadius = null;
        AnimatableFloatValue innerRoundedness = null;
        block22: while (reader.hasNext()) {
            switch (reader.nextName()) {
                case "nm": {
                    name = reader.nextString();
                    continue block22;
                }
                case "sy": {
                    type = PolystarShape.Type.forValue(reader.nextInt());
                    continue block22;
                }
                case "pt": {
                    points = AnimatableValueParser.parseFloat(reader, composition, false);
                    continue block22;
                }
                case "p": {
                    position = AnimatablePathValueParser.parseSplitPath(reader, composition);
                    continue block22;
                }
                case "r": {
                    rotation = AnimatableValueParser.parseFloat(reader, composition, false);
                    continue block22;
                }
                case "or": {
                    outerRadius = AnimatableValueParser.parseFloat(reader, composition);
                    continue block22;
                }
                case "os": {
                    outerRoundedness = AnimatableValueParser.parseFloat(reader, composition, false);
                    continue block22;
                }
                case "ir": {
                    innerRadius = AnimatableValueParser.parseFloat(reader, composition);
                    continue block22;
                }
                case "is": {
                    innerRoundedness = AnimatableValueParser.parseFloat(reader, composition, false);
                    continue block22;
                }
            }
            reader.skipValue();
        }
        return new PolystarShape(name, type, points, position, rotation, innerRadius, outerRadius, innerRoundedness, outerRoundedness);
    }
}

