/*
 * Decompiled with CFR 0.152.
 */
package com.airbnb.lottie.value;

import android.graphics.PointF;
import android.support.annotation.FloatRange;
import android.support.annotation.Nullable;
import android.view.animation.Interpolator;
import com.airbnb.lottie.LottieComposition;

public class Keyframe<T> {
    @Nullable
    private final LottieComposition composition;
    @Nullable
    public final T startValue;
    @Nullable
    public final T endValue;
    @Nullable
    public final Interpolator interpolator;
    public final float startFrame;
    @Nullable
    public Float endFrame;
    private float startProgress = Float.MIN_VALUE;
    private float endProgress = Float.MIN_VALUE;
    public PointF pathCp1 = null;
    public PointF pathCp2 = null;

    public Keyframe(LottieComposition composition, @Nullable T startValue, @Nullable T endValue, @Nullable Interpolator interpolator, float startFrame, @Nullable Float endFrame) {
        this.composition = composition;
        this.startValue = startValue;
        this.endValue = endValue;
        this.interpolator = interpolator;
        this.startFrame = startFrame;
        this.endFrame = endFrame;
    }

    public Keyframe(T value) {
        this.composition = null;
        this.startValue = value;
        this.endValue = value;
        this.interpolator = null;
        this.startFrame = Float.MIN_VALUE;
        this.endFrame = Float.valueOf(Float.MAX_VALUE);
    }

    public float getStartProgress() {
        if (this.composition == null) {
            return 0.0f;
        }
        if (this.startProgress == Float.MIN_VALUE) {
            this.startProgress = (this.startFrame - this.composition.getStartFrame()) / this.composition.getDurationFrames();
        }
        return this.startProgress;
    }

    public float getEndProgress() {
        if (this.composition == null) {
            return 1.0f;
        }
        if (this.endProgress == Float.MIN_VALUE) {
            if (this.endFrame == null) {
                this.endProgress = 1.0f;
            } else {
                float startProgress = this.getStartProgress();
                float durationFrames = this.endFrame.floatValue() - this.startFrame;
                float durationProgress = durationFrames / this.composition.getDurationFrames();
                this.endProgress = startProgress + durationProgress;
            }
        }
        return this.endProgress;
    }

    public boolean isStatic() {
        return this.interpolator == null;
    }

    public boolean containsProgress(@FloatRange(from=0.0, to=1.0) float progress) {
        return progress >= this.getStartProgress() && progress < this.getEndProgress();
    }

    public String toString() {
        return "Keyframe{startValue=" + this.startValue + ", endValue=" + this.endValue + ", startFrame=" + this.startFrame + ", endFrame=" + this.endFrame + ", interpolator=" + this.interpolator + '}';
    }
}

