/*
 * Decompiled with CFR 0.152.
 */
package com.airbnb.lottie;

import android.content.Context;
import android.content.res.Resources;
import android.graphics.Rect;
import android.os.AsyncTask;
import android.support.annotation.Nullable;
import android.support.annotation.RawRes;
import android.support.annotation.RestrictTo;
import android.support.v4.util.LongSparseArray;
import android.support.v4.util.SparseArrayCompat;
import android.util.JsonReader;
import android.util.Log;
import com.airbnb.lottie.Cancellable;
import com.airbnb.lottie.LottieImageAsset;
import com.airbnb.lottie.OnCompositionLoadedListener;
import com.airbnb.lottie.PerformanceTracker;
import com.airbnb.lottie.model.Font;
import com.airbnb.lottie.model.FontCharacter;
import com.airbnb.lottie.model.layer.Layer;
import com.airbnb.lottie.parser.AsyncCompositionLoader;
import com.airbnb.lottie.parser.LottieCompositionParser;
import com.airbnb.lottie.utils.Utils;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.json.JSONObject;

public class LottieComposition {
    private final PerformanceTracker performanceTracker = new PerformanceTracker();
    private final HashSet<String> warnings = new HashSet();
    private Map<String, List<Layer>> precomps;
    private Map<String, LottieImageAsset> images;
    private Map<String, Font> fonts;
    private SparseArrayCompat<FontCharacter> characters;
    private LongSparseArray<Layer> layerMap;
    private List<Layer> layers;
    private Rect bounds;
    private float startFrame;
    private float endFrame;
    private float frameRate;

    public void init(Rect bounds, float startFrame, float endFrame, float frameRate, List<Layer> layers, LongSparseArray<Layer> layerMap, Map<String, List<Layer>> precomps, Map<String, LottieImageAsset> images, SparseArrayCompat<FontCharacter> characters, Map<String, Font> fonts) {
        this.bounds = bounds;
        this.startFrame = startFrame;
        this.endFrame = endFrame;
        this.frameRate = frameRate;
        this.layers = layers;
        this.layerMap = layerMap;
        this.precomps = precomps;
        this.images = images;
        this.characters = characters;
        this.fonts = fonts;
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY})
    public void addWarning(String warning) {
        Log.w((String)"LOTTIE", (String)warning);
        this.warnings.add(warning);
    }

    public ArrayList<String> getWarnings() {
        return new ArrayList<String>(Arrays.asList(this.warnings.toArray(new String[this.warnings.size()])));
    }

    public void setPerformanceTrackingEnabled(boolean enabled) {
        this.performanceTracker.setEnabled(enabled);
    }

    public PerformanceTracker getPerformanceTracker() {
        return this.performanceTracker;
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY})
    public Layer layerModelForId(long id) {
        return (Layer)this.layerMap.get(id);
    }

    public Rect getBounds() {
        return this.bounds;
    }

    public float getDuration() {
        return (long)(this.getDurationFrames() / this.frameRate * 1000.0f);
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY})
    public float getStartFrame() {
        return this.startFrame;
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY})
    public float getEndFrame() {
        return this.endFrame;
    }

    public float getFrameRate() {
        return this.frameRate;
    }

    public List<Layer> getLayers() {
        return this.layers;
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY})
    @Nullable
    public List<Layer> getPrecomps(String id) {
        return this.precomps.get(id);
    }

    public SparseArrayCompat<FontCharacter> getCharacters() {
        return this.characters;
    }

    public Map<String, Font> getFonts() {
        return this.fonts;
    }

    public boolean hasImages() {
        return !this.images.isEmpty();
    }

    public Map<String, LottieImageAsset> getImages() {
        return this.images;
    }

    public float getDurationFrames() {
        return this.endFrame - this.startFrame;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("LottieComposition:\n");
        for (Layer layer : this.layers) {
            sb.append(layer.toString("\t"));
        }
        return sb.toString();
    }

    public static class Factory {
        private Factory() {
        }

        public static Cancellable fromAssetFileName(Context context, String fileName, OnCompositionLoadedListener listener) {
            InputStream stream;
            try {
                stream = context.getAssets().open(fileName);
            }
            catch (IOException e) {
                throw new IllegalArgumentException("Unable to find file " + fileName, e);
            }
            return Factory.fromInputStream(stream, listener);
        }

        public static Cancellable fromRawFile(Context context, @RawRes int resId, OnCompositionLoadedListener listener) {
            return Factory.fromInputStream(context.getResources().openRawResource(resId), listener);
        }

        public static Cancellable fromInputStream(InputStream stream, OnCompositionLoadedListener listener) {
            return Factory.fromJsonReader(new JsonReader((Reader)new InputStreamReader(stream)), listener);
        }

        public static Cancellable fromJsonString(String jsonString, OnCompositionLoadedListener listener) {
            return Factory.fromJsonReader(new JsonReader((Reader)new StringReader(jsonString)), listener);
        }

        public static Cancellable fromJsonReader(JsonReader reader, OnCompositionLoadedListener listener) {
            AsyncCompositionLoader loader = new AsyncCompositionLoader(listener);
            loader.executeOnExecutor(AsyncTask.THREAD_POOL_EXECUTOR, new JsonReader[]{reader});
            return loader;
        }

        @Nullable
        public static LottieComposition fromFileSync(Context context, String fileName) {
            try {
                return Factory.fromInputStreamSync(context.getAssets().open(fileName));
            }
            catch (IOException e) {
                throw new IllegalArgumentException("Unable to open asset " + fileName, e);
            }
        }

        @Nullable
        public static LottieComposition fromInputStreamSync(InputStream stream) {
            LottieComposition composition;
            try {
                composition = Factory.fromJsonSync(new JsonReader((Reader)new InputStreamReader(stream)));
            }
            catch (IOException e) {
                throw new IllegalArgumentException("Unable to parse composition.", e);
            }
            finally {
                Utils.closeQuietly(stream);
            }
            return composition;
        }

        @Deprecated
        public static LottieComposition fromJsonSync(Resources res, JSONObject json) {
            return Factory.fromJsonSync(json.toString());
        }

        public static LottieComposition fromJsonSync(String string) {
            try {
                return Factory.fromJsonSync(new JsonReader((Reader)new StringReader(string)));
            }
            catch (IOException e) {
                throw new IllegalArgumentException(e);
            }
        }

        public static LottieComposition fromJsonSync(JsonReader reader) throws IOException {
            return LottieCompositionParser.parse(reader);
        }
    }
}

