/*
 * Decompiled with CFR 0.152.
 */
package com.airbnb.lottie.model.layer;

import android.graphics.Color;
import android.graphics.Rect;
import android.support.annotation.Nullable;
import android.util.JsonReader;
import com.airbnb.lottie.LottieComposition;
import com.airbnb.lottie.animation.Keyframe;
import com.airbnb.lottie.model.animatable.AnimatableFloatValue;
import com.airbnb.lottie.model.animatable.AnimatableTextFrame;
import com.airbnb.lottie.model.animatable.AnimatableTextProperties;
import com.airbnb.lottie.model.animatable.AnimatableTransform;
import com.airbnb.lottie.model.content.ContentModel;
import com.airbnb.lottie.model.content.Mask;
import com.airbnb.lottie.model.content.ShapeGroup;
import com.airbnb.lottie.utils.Utils;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;

public class Layer {
    private final List<ContentModel> shapes;
    private final LottieComposition composition;
    private final String layerName;
    private final long layerId;
    private final LayerType layerType;
    private final long parentId;
    @Nullable
    private final String refId;
    private final List<Mask> masks;
    private final AnimatableTransform transform;
    private final int solidWidth;
    private final int solidHeight;
    private final int solidColor;
    private final float timeStretch;
    private final float startFrame;
    private final int preCompWidth;
    private final int preCompHeight;
    @Nullable
    private final AnimatableTextFrame text;
    @Nullable
    private final AnimatableTextProperties textProperties;
    @Nullable
    private final AnimatableFloatValue timeRemapping;
    private final List<Keyframe<Float>> inOutKeyframes;
    private final MatteType matteType;

    private Layer(List<ContentModel> shapes, LottieComposition composition, String layerName, long layerId, LayerType layerType, long parentId, @Nullable String refId, List<Mask> masks, AnimatableTransform transform, int solidWidth, int solidHeight, int solidColor, float timeStretch, float startFrame, int preCompWidth, int preCompHeight, @Nullable AnimatableTextFrame text, @Nullable AnimatableTextProperties textProperties, List<Keyframe<Float>> inOutKeyframes, MatteType matteType, @Nullable AnimatableFloatValue timeRemapping) {
        this.shapes = shapes;
        this.composition = composition;
        this.layerName = layerName;
        this.layerId = layerId;
        this.layerType = layerType;
        this.parentId = parentId;
        this.refId = refId;
        this.masks = masks;
        this.transform = transform;
        this.solidWidth = solidWidth;
        this.solidHeight = solidHeight;
        this.solidColor = solidColor;
        this.timeStretch = timeStretch;
        this.startFrame = startFrame;
        this.preCompWidth = preCompWidth;
        this.preCompHeight = preCompHeight;
        this.text = text;
        this.textProperties = textProperties;
        this.inOutKeyframes = inOutKeyframes;
        this.matteType = matteType;
        this.timeRemapping = timeRemapping;
    }

    LottieComposition getComposition() {
        return this.composition;
    }

    float getTimeStretch() {
        return this.timeStretch;
    }

    float getStartProgress() {
        return this.startFrame / this.composition.getDurationFrames();
    }

    List<Keyframe<Float>> getInOutKeyframes() {
        return this.inOutKeyframes;
    }

    public long getId() {
        return this.layerId;
    }

    String getName() {
        return this.layerName;
    }

    @Nullable
    String getRefId() {
        return this.refId;
    }

    int getPreCompWidth() {
        return this.preCompWidth;
    }

    int getPreCompHeight() {
        return this.preCompHeight;
    }

    List<Mask> getMasks() {
        return this.masks;
    }

    public LayerType getLayerType() {
        return this.layerType;
    }

    MatteType getMatteType() {
        return this.matteType;
    }

    long getParentId() {
        return this.parentId;
    }

    List<ContentModel> getShapes() {
        return this.shapes;
    }

    AnimatableTransform getTransform() {
        return this.transform;
    }

    int getSolidColor() {
        return this.solidColor;
    }

    int getSolidHeight() {
        return this.solidHeight;
    }

    int getSolidWidth() {
        return this.solidWidth;
    }

    @Nullable
    AnimatableTextFrame getText() {
        return this.text;
    }

    @Nullable
    AnimatableTextProperties getTextProperties() {
        return this.textProperties;
    }

    @Nullable
    AnimatableFloatValue getTimeRemapping() {
        return this.timeRemapping;
    }

    public String toString() {
        return this.toString("");
    }

    public String toString(String prefix) {
        StringBuilder sb = new StringBuilder();
        sb.append(prefix).append(this.getName()).append("\n");
        Layer parent = this.composition.layerModelForId(this.getParentId());
        if (parent != null) {
            sb.append("\t\tParents: ").append(parent.getName());
            parent = this.composition.layerModelForId(parent.getParentId());
            while (parent != null) {
                sb.append("->").append(parent.getName());
                parent = this.composition.layerModelForId(parent.getParentId());
            }
            sb.append(prefix).append("\n");
        }
        if (!this.getMasks().isEmpty()) {
            sb.append(prefix).append("\tMasks: ").append(this.getMasks().size()).append("\n");
        }
        if (this.getSolidWidth() != 0 && this.getSolidHeight() != 0) {
            sb.append(prefix).append("\tBackground: ").append(String.format(Locale.US, "%dx%d %X\n", this.getSolidWidth(), this.getSolidHeight(), this.getSolidColor()));
        }
        if (!this.shapes.isEmpty()) {
            sb.append(prefix).append("\tShapes:\n");
            for (ContentModel shape : this.shapes) {
                sb.append(prefix).append("\t\t").append(shape).append("\n");
            }
        }
        return sb.toString();
    }

    public static class Factory {
        private Factory() {
        }

        public static Layer newInstance(LottieComposition composition) {
            Rect bounds = composition.getBounds();
            return new Layer(Collections.emptyList(), composition, "__container", -1L, LayerType.PreComp, -1L, null, Collections.emptyList(), AnimatableTransform.Factory.newInstance(), 0, 0, 0, 0.0f, 0.0f, bounds.width(), bounds.height(), null, null, Collections.emptyList(), MatteType.None, null);
        }

        public static Layer newInstance(JsonReader reader, LottieComposition composition) throws IOException {
            String layerName = null;
            LayerType layerType = null;
            String refId = null;
            long layerId = 0L;
            int solidWidth = 0;
            int solidHeight = 0;
            int solidColor = 0;
            int preCompWidth = 0;
            int preCompHeight = 0;
            long parentId = -1L;
            float timeStretch = 1.0f;
            float startFrame = 0.0f;
            float inFrame = 0.0f;
            float outFrame = 0.0f;
            String cl = null;
            MatteType matteType = MatteType.None;
            AnimatableTransform transform = null;
            AnimatableTextFrame text = null;
            AnimatableTextProperties textProperties = null;
            AnimatableFloatValue timeRemapping = null;
            ArrayList<Mask> masks = new ArrayList<Mask>();
            ArrayList<Object> shapes = new ArrayList<Object>();
            reader.beginObject();
            block62: while (reader.hasNext()) {
                switch (reader.nextName()) {
                    case "nm": {
                        layerName = reader.nextString();
                        continue block62;
                    }
                    case "ind": {
                        layerId = reader.nextInt();
                        continue block62;
                    }
                    case "refId": {
                        refId = reader.nextString();
                        continue block62;
                    }
                    case "ty": {
                        int layerTypeInt = reader.nextInt();
                        if (layerTypeInt < LayerType.Unknown.ordinal()) {
                            layerType = LayerType.values()[layerTypeInt];
                            continue block62;
                        }
                        layerType = LayerType.Unknown;
                        continue block62;
                    }
                    case "parent": {
                        parentId = reader.nextInt();
                        continue block62;
                    }
                    case "sw": {
                        solidWidth = (int)((float)reader.nextInt() * Utils.dpScale());
                        continue block62;
                    }
                    case "sh": {
                        solidHeight = (int)((float)reader.nextInt() * Utils.dpScale());
                        continue block62;
                    }
                    case "sc": {
                        solidColor = Color.parseColor((String)reader.nextString());
                        continue block62;
                    }
                    case "ks": {
                        transform = AnimatableTransform.Factory.newInstance(reader, composition);
                        continue block62;
                    }
                    case "tt": {
                        matteType = MatteType.values()[reader.nextInt()];
                        continue block62;
                    }
                    case "masksProperties": {
                        reader.beginArray();
                        while (reader.hasNext()) {
                            masks.add(Mask.Factory.newMask(reader, composition));
                        }
                        reader.endArray();
                        continue block62;
                    }
                    case "shapes": {
                        reader.beginArray();
                        while (reader.hasNext()) {
                            Object shape = ShapeGroup.shapeItemWithJson(reader, composition);
                            if (shape == null) continue;
                            shapes.add(shape);
                        }
                        reader.endArray();
                        continue block62;
                    }
                    case "t": {
                        reader.beginObject();
                        block65: while (reader.hasNext()) {
                            switch (reader.nextName()) {
                                case "d": {
                                    text = AnimatableTextFrame.Factory.newInstance(reader, composition);
                                    continue block65;
                                }
                                case "a": {
                                    reader.beginArray();
                                    if (reader.hasNext()) {
                                        textProperties = AnimatableTextProperties.Factory.newInstance(reader, composition);
                                    }
                                    while (reader.hasNext()) {
                                        reader.skipValue();
                                    }
                                    reader.endArray();
                                    continue block65;
                                }
                            }
                            reader.skipValue();
                        }
                        reader.endObject();
                        continue block62;
                    }
                    case "ef": {
                        reader.beginArray();
                        ArrayList<String> effectNames = new ArrayList<String>();
                        while (reader.hasNext()) {
                            reader.beginObject();
                            block68: while (reader.hasNext()) {
                                switch (reader.nextName()) {
                                    case "nm": {
                                        effectNames.add(reader.nextString());
                                        continue block68;
                                    }
                                }
                                reader.skipValue();
                            }
                            reader.endObject();
                        }
                        reader.endArray();
                        composition.addWarning("Lottie doesn't support layer effects. If you are using them for  fills, strokes, trim paths etc. then try adding them directly as contents  in your shape. Found: " + effectNames);
                        continue block62;
                    }
                    case "sr": {
                        timeStretch = (float)reader.nextDouble();
                        continue block62;
                    }
                    case "st": {
                        startFrame = (float)reader.nextDouble();
                        continue block62;
                    }
                    case "w": {
                        preCompWidth = (int)((float)reader.nextInt() * Utils.dpScale());
                        continue block62;
                    }
                    case "h": {
                        preCompHeight = (int)((float)reader.nextInt() * Utils.dpScale());
                        continue block62;
                    }
                    case "ip": {
                        inFrame = (float)reader.nextDouble();
                        continue block62;
                    }
                    case "op": {
                        outFrame = (float)reader.nextDouble();
                        continue block62;
                    }
                    case "tm": {
                        timeRemapping = AnimatableFloatValue.Factory.newInstance(reader, composition, false);
                        continue block62;
                    }
                    case "cl": {
                        cl = reader.nextString();
                        continue block62;
                    }
                }
                reader.skipValue();
            }
            reader.endObject();
            inFrame /= timeStretch;
            outFrame /= timeStretch;
            ArrayList<Keyframe<Float>> inOutKeyframes = new ArrayList<Keyframe<Float>>();
            if (inFrame > 0.0f) {
                Keyframe<Float> preKeyframe = new Keyframe<Float>(composition, Float.valueOf(0.0f), Float.valueOf(0.0f), null, 0.0f, Float.valueOf(inFrame));
                inOutKeyframes.add(preKeyframe);
            }
            outFrame = (outFrame > 0.0f ? outFrame : composition.getEndFrame()) + 1.0f;
            Keyframe<Float> visibleKeyframe = new Keyframe<Float>(composition, Float.valueOf(1.0f), Float.valueOf(1.0f), null, inFrame, Float.valueOf(outFrame));
            inOutKeyframes.add(visibleKeyframe);
            Keyframe<Float> outKeyframe = new Keyframe<Float>(composition, Float.valueOf(0.0f), Float.valueOf(0.0f), null, outFrame, Float.valueOf(Float.MAX_VALUE));
            inOutKeyframes.add(outKeyframe);
            if (layerName.endsWith(".ai") || "ai".equals(cl)) {
                composition.addWarning("Convert your Illustrator layers to shape layers.");
            }
            if (layerType == LayerType.Text && !Utils.isAtLeastVersion(composition, 4, 8, 0)) {
                layerType = LayerType.Unknown;
                composition.addWarning("Text is only supported on bodymovin >= 4.8.0");
            }
            return new Layer(shapes, composition, layerName, layerId, layerType, parentId, refId, masks, transform, solidWidth, solidHeight, solidColor, timeStretch, startFrame, preCompWidth, preCompHeight, text, textProperties, inOutKeyframes, matteType, timeRemapping);
        }
    }

    static enum MatteType {
        None,
        Add,
        Invert,
        Unknown;

    }

    public static enum LayerType {
        PreComp,
        Solid,
        Image,
        Null,
        Shape,
        Text,
        Unknown;

    }
}

