/*
 * Decompiled with CFR 0.152.
 */
package com.airbnb.lottie.model.content;

import android.util.JsonReader;
import com.airbnb.lottie.LottieComposition;
import com.airbnb.lottie.LottieDrawable;
import com.airbnb.lottie.animation.content.Content;
import com.airbnb.lottie.animation.content.TrimPathContent;
import com.airbnb.lottie.model.animatable.AnimatableFloatValue;
import com.airbnb.lottie.model.content.ContentModel;
import com.airbnb.lottie.model.layer.BaseLayer;
import java.io.IOException;

public class ShapeTrimPath
implements ContentModel {
    private final String name;
    private final Type type;
    private final AnimatableFloatValue start;
    private final AnimatableFloatValue end;
    private final AnimatableFloatValue offset;

    private ShapeTrimPath(String name, Type type, AnimatableFloatValue start, AnimatableFloatValue end, AnimatableFloatValue offset) {
        this.name = name;
        this.type = type;
        this.start = start;
        this.end = end;
        this.offset = offset;
    }

    public String getName() {
        return this.name;
    }

    public Type getType() {
        return this.type;
    }

    public AnimatableFloatValue getEnd() {
        return this.end;
    }

    public AnimatableFloatValue getStart() {
        return this.start;
    }

    public AnimatableFloatValue getOffset() {
        return this.offset;
    }

    @Override
    public Content toContent(LottieDrawable drawable, BaseLayer layer) {
        return new TrimPathContent(layer, this);
    }

    public String toString() {
        return "Trim Path: {start: " + this.start + ", end: " + this.end + ", offset: " + this.offset + "}";
    }

    static class Factory {
        private Factory() {
        }

        static ShapeTrimPath newInstance(JsonReader reader, LottieComposition composition) throws IOException {
            String name = null;
            Type type = null;
            AnimatableFloatValue start = null;
            AnimatableFloatValue end = null;
            AnimatableFloatValue offset = null;
            block14: while (reader.hasNext()) {
                switch (reader.nextName()) {
                    case "s": {
                        start = AnimatableFloatValue.Factory.newInstance(reader, composition, false);
                        continue block14;
                    }
                    case "e": {
                        end = AnimatableFloatValue.Factory.newInstance(reader, composition, false);
                        continue block14;
                    }
                    case "o": {
                        offset = AnimatableFloatValue.Factory.newInstance(reader, composition, false);
                        continue block14;
                    }
                    case "nm": {
                        name = reader.nextString();
                        continue block14;
                    }
                    case "m": {
                        type = Type.forId(reader.nextInt());
                        continue block14;
                    }
                }
                reader.skipValue();
            }
            return new ShapeTrimPath(name, type, start, end, offset);
        }
    }

    public static enum Type {
        Simultaneously,
        Individually;


        static Type forId(int id) {
            switch (id) {
                case 1: {
                    return Simultaneously;
                }
                case 2: {
                    return Individually;
                }
            }
            throw new IllegalArgumentException("Unknown trim path type " + id);
        }
    }
}

