/*
 * Decompiled with CFR 0.152.
 */
package com.airbnb.lottie.model.content;

import android.graphics.Paint;
import android.support.annotation.Nullable;
import android.util.JsonReader;
import com.airbnb.lottie.LottieComposition;
import com.airbnb.lottie.LottieDrawable;
import com.airbnb.lottie.animation.content.Content;
import com.airbnb.lottie.animation.content.StrokeContent;
import com.airbnb.lottie.model.animatable.AnimatableColorValue;
import com.airbnb.lottie.model.animatable.AnimatableFloatValue;
import com.airbnb.lottie.model.animatable.AnimatableIntegerValue;
import com.airbnb.lottie.model.content.ContentModel;
import com.airbnb.lottie.model.layer.BaseLayer;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class ShapeStroke
implements ContentModel {
    private final String name;
    @Nullable
    private final AnimatableFloatValue offset;
    private final List<AnimatableFloatValue> lineDashPattern;
    private final AnimatableColorValue color;
    private final AnimatableIntegerValue opacity;
    private final AnimatableFloatValue width;
    private final LineCapType capType;
    private final LineJoinType joinType;

    private ShapeStroke(String name, @Nullable AnimatableFloatValue offset, List<AnimatableFloatValue> lineDashPattern, AnimatableColorValue color, AnimatableIntegerValue opacity, AnimatableFloatValue width, LineCapType capType, LineJoinType joinType) {
        this.name = name;
        this.offset = offset;
        this.lineDashPattern = lineDashPattern;
        this.color = color;
        this.opacity = opacity;
        this.width = width;
        this.capType = capType;
        this.joinType = joinType;
    }

    @Override
    public Content toContent(LottieDrawable drawable, BaseLayer layer) {
        return new StrokeContent(drawable, layer, this);
    }

    public String getName() {
        return this.name;
    }

    public AnimatableColorValue getColor() {
        return this.color;
    }

    public AnimatableIntegerValue getOpacity() {
        return this.opacity;
    }

    public AnimatableFloatValue getWidth() {
        return this.width;
    }

    public List<AnimatableFloatValue> getLineDashPattern() {
        return this.lineDashPattern;
    }

    public AnimatableFloatValue getDashOffset() {
        return this.offset;
    }

    public LineCapType getCapType() {
        return this.capType;
    }

    public LineJoinType getJoinType() {
        return this.joinType;
    }

    static class Factory {
        private Factory() {
        }

        static ShapeStroke newInstance(JsonReader reader, LottieComposition composition) throws IOException {
            String name = null;
            AnimatableColorValue color = null;
            AnimatableFloatValue width = null;
            AnimatableIntegerValue opacity = null;
            LineCapType capType = null;
            LineJoinType joinType = null;
            AnimatableFloatValue offset = null;
            ArrayList<AnimatableFloatValue> lineDashPattern = new ArrayList<AnimatableFloatValue>();
            block35: while (reader.hasNext()) {
                switch (reader.nextName()) {
                    case "nm": {
                        name = reader.nextString();
                        continue block35;
                    }
                    case "c": {
                        color = AnimatableColorValue.Factory.newInstance(reader, composition);
                        continue block35;
                    }
                    case "w": {
                        width = AnimatableFloatValue.Factory.newInstance(reader, composition);
                        continue block35;
                    }
                    case "o": {
                        opacity = AnimatableIntegerValue.Factory.newInstance(reader, composition);
                        continue block35;
                    }
                    case "lc": {
                        capType = LineCapType.values()[reader.nextInt() - 1];
                        continue block35;
                    }
                    case "lj": {
                        joinType = LineJoinType.values()[reader.nextInt() - 1];
                        continue block35;
                    }
                    case "d": {
                        reader.beginArray();
                        while (reader.hasNext()) {
                            String n = null;
                            AnimatableFloatValue val = null;
                            reader.beginObject();
                            block37: while (reader.hasNext()) {
                                switch (reader.nextName()) {
                                    case "n": {
                                        n = reader.nextString();
                                        continue block37;
                                    }
                                    case "v": {
                                        val = AnimatableFloatValue.Factory.newInstance(reader, composition);
                                        continue block37;
                                    }
                                }
                                reader.skipValue();
                            }
                            reader.endObject();
                            switch (n) {
                                case "o": {
                                    offset = val;
                                    break;
                                }
                                case "d": 
                                case "g": {
                                    lineDashPattern.add(val);
                                }
                            }
                        }
                        reader.endArray();
                        if (lineDashPattern.size() != 1) continue block35;
                        lineDashPattern.add((AnimatableFloatValue)lineDashPattern.get(0));
                        continue block35;
                    }
                }
                reader.skipValue();
            }
            return new ShapeStroke(name, offset, lineDashPattern, color, opacity, width, capType, joinType);
        }
    }

    public static enum LineJoinType {
        Miter,
        Round,
        Bevel;


        public Paint.Join toPaintJoin() {
            switch (this) {
                case Bevel: {
                    return Paint.Join.BEVEL;
                }
                case Miter: {
                    return Paint.Join.MITER;
                }
                case Round: {
                    return Paint.Join.ROUND;
                }
            }
            return null;
        }
    }

    public static enum LineCapType {
        Butt,
        Round,
        Unknown;


        public Paint.Cap toPaintCap() {
            switch (this) {
                case Butt: {
                    return Paint.Cap.BUTT;
                }
                case Round: {
                    return Paint.Cap.ROUND;
                }
            }
            return Paint.Cap.SQUARE;
        }
    }
}

