/*
 * Decompiled with CFR 0.152.
 */
package com.airbnb.lottie.model.content;

import android.support.annotation.Nullable;
import android.util.JsonReader;
import android.util.Log;
import com.airbnb.lottie.LottieDrawable;
import com.airbnb.lottie.animation.content.Content;
import com.airbnb.lottie.animation.content.MergePathsContent;
import com.airbnb.lottie.model.content.ContentModel;
import com.airbnb.lottie.model.layer.BaseLayer;
import java.io.IOException;

public class MergePaths
implements ContentModel {
    private final String name;
    private final MergePathsMode mode;

    private MergePaths(String name, MergePathsMode mode) {
        this.name = name;
        this.mode = mode;
    }

    public String getName() {
        return this.name;
    }

    public MergePathsMode getMode() {
        return this.mode;
    }

    @Override
    @Nullable
    public Content toContent(LottieDrawable drawable, BaseLayer layer) {
        if (!drawable.enableMergePathsForKitKatAndAbove()) {
            Log.w((String)"LOTTIE", (String)"Animation contains merge paths but they are disabled.");
            return null;
        }
        return new MergePathsContent(this);
    }

    public String toString() {
        return "MergePaths{mode=" + (Object)((Object)this.mode) + '}';
    }

    static class Factory {
        private Factory() {
        }

        static MergePaths newInstance(JsonReader reader) throws IOException {
            String name = null;
            MergePathsMode mode = null;
            block8: while (reader.hasNext()) {
                switch (reader.nextName()) {
                    case "nm": {
                        name = reader.nextString();
                        continue block8;
                    }
                    case "mm": {
                        mode = MergePathsMode.forId(reader.nextInt());
                        continue block8;
                    }
                }
                reader.skipValue();
            }
            return new MergePaths(name, mode);
        }
    }

    public static enum MergePathsMode {
        Merge,
        Add,
        Subtract,
        Intersect,
        ExcludeIntersections;


        private static MergePathsMode forId(int id) {
            switch (id) {
                case 1: {
                    return Merge;
                }
                case 2: {
                    return Add;
                }
                case 3: {
                    return Subtract;
                }
                case 4: {
                    return Intersect;
                }
                case 5: {
                    return ExcludeIntersections;
                }
            }
            return Merge;
        }
    }
}

