/*
 * Decompiled with CFR 0.152.
 */
package com.airbnb.lottie.model.animatable;

import android.support.annotation.Nullable;
import android.util.JsonReader;
import com.airbnb.lottie.LottieComposition;
import com.airbnb.lottie.animation.Keyframe;
import com.airbnb.lottie.model.animatable.AnimatableValue;
import java.io.IOException;
import java.util.List;

class AnimatableValueParser<T> {
    private final JsonReader reader;
    private final float scale;
    private final LottieComposition composition;
    private final AnimatableValue.Factory<T> valueFactory;

    private AnimatableValueParser(JsonReader reader, float scale, LottieComposition composition, AnimatableValue.Factory<T> valueFactory) {
        this.reader = reader;
        this.scale = scale;
        this.composition = composition;
        this.valueFactory = valueFactory;
    }

    @Nullable
    static <T> List<Keyframe<T>> newInstance(JsonReader reader, float scale, LottieComposition composition, AnimatableValue.Factory<T> valueFactory) throws IOException {
        AnimatableValueParser<T> parser = new AnimatableValueParser<T>(reader, scale, composition, valueFactory);
        return super.parseKeyframes();
    }

    private List<Keyframe<T>> parseKeyframes() throws IOException {
        return Keyframe.Factory.parseKeyframes(this.reader, this.composition, this.scale, this.valueFactory);
    }
}

