/*
 * Decompiled with CFR 0.152.
 */
package com.airbnb.lottie.model.animatable;

import android.graphics.PointF;
import android.support.annotation.Nullable;
import android.util.JsonReader;
import android.util.JsonToken;
import android.util.Log;
import com.airbnb.lottie.LottieComposition;
import com.airbnb.lottie.LottieDrawable;
import com.airbnb.lottie.animation.content.Content;
import com.airbnb.lottie.animation.content.ModifierContent;
import com.airbnb.lottie.animation.keyframe.TransformKeyframeAnimation;
import com.airbnb.lottie.model.animatable.AnimatableFloatValue;
import com.airbnb.lottie.model.animatable.AnimatableIntegerValue;
import com.airbnb.lottie.model.animatable.AnimatablePathValue;
import com.airbnb.lottie.model.animatable.AnimatableScaleValue;
import com.airbnb.lottie.model.animatable.AnimatableValue;
import com.airbnb.lottie.model.content.ContentModel;
import com.airbnb.lottie.model.layer.BaseLayer;
import com.airbnb.lottie.value.ScaleXY;
import java.io.IOException;

public class AnimatableTransform
implements ModifierContent,
ContentModel {
    private final AnimatablePathValue anchorPoint;
    private final AnimatableValue<PointF, PointF> position;
    private final AnimatableScaleValue scale;
    private final AnimatableFloatValue rotation;
    private final AnimatableIntegerValue opacity;
    @Nullable
    private final AnimatableFloatValue startOpacity;
    @Nullable
    private final AnimatableFloatValue endOpacity;

    private AnimatableTransform(AnimatablePathValue anchorPoint, AnimatableValue<PointF, PointF> position, AnimatableScaleValue scale, AnimatableFloatValue rotation, AnimatableIntegerValue opacity, @Nullable AnimatableFloatValue startOpacity, @Nullable AnimatableFloatValue endOpacity) {
        this.anchorPoint = anchorPoint;
        this.position = position;
        this.scale = scale;
        this.rotation = rotation;
        this.opacity = opacity;
        this.startOpacity = startOpacity;
        this.endOpacity = endOpacity;
    }

    public AnimatablePathValue getAnchorPoint() {
        return this.anchorPoint;
    }

    public AnimatableValue<PointF, PointF> getPosition() {
        return this.position;
    }

    public AnimatableScaleValue getScale() {
        return this.scale;
    }

    public AnimatableFloatValue getRotation() {
        return this.rotation;
    }

    public AnimatableIntegerValue getOpacity() {
        return this.opacity;
    }

    @Nullable
    public AnimatableFloatValue getStartOpacity() {
        return this.startOpacity;
    }

    @Nullable
    public AnimatableFloatValue getEndOpacity() {
        return this.endOpacity;
    }

    public TransformKeyframeAnimation createAnimation() {
        return new TransformKeyframeAnimation(this);
    }

    @Override
    @Nullable
    public Content toContent(LottieDrawable drawable, BaseLayer layer) {
        return null;
    }

    public static class Factory {
        private Factory() {
        }

        public static AnimatableTransform newInstance() {
            AnimatablePathValue anchorPoint = new AnimatablePathValue();
            AnimatablePathValue position = new AnimatablePathValue();
            AnimatableScaleValue scale = AnimatableScaleValue.Factory.newInstance();
            AnimatableFloatValue rotation = AnimatableFloatValue.Factory.newInstance();
            AnimatableIntegerValue opacity = AnimatableIntegerValue.Factory.newInstance();
            AnimatableFloatValue startOpacity = AnimatableFloatValue.Factory.newInstance();
            AnimatableFloatValue endOpacity = AnimatableFloatValue.Factory.newInstance();
            return new AnimatableTransform(anchorPoint, position, scale, rotation, opacity, startOpacity, endOpacity);
        }

        public static AnimatableTransform newInstance(JsonReader reader, LottieComposition composition) throws IOException {
            boolean isObject;
            AnimatablePathValue anchorPoint = null;
            AnimatableValue<PointF, PointF> position = null;
            AnimatableScaleValue scale = null;
            AnimatableFloatValue rotation = null;
            AnimatableIntegerValue opacity = null;
            AnimatableFloatValue startOpacity = null;
            AnimatableFloatValue endOpacity = null;
            boolean bl = isObject = reader.peek() == JsonToken.BEGIN_OBJECT;
            if (isObject) {
                reader.beginObject();
            }
            block20: while (reader.hasNext()) {
                switch (reader.nextName()) {
                    case "a": {
                        reader.beginObject();
                        while (reader.hasNext()) {
                            if (reader.nextName().equals("k")) {
                                anchorPoint = new AnimatablePathValue(reader, composition);
                                continue;
                            }
                            reader.skipValue();
                        }
                        reader.endObject();
                        continue block20;
                    }
                    case "p": {
                        position = AnimatablePathValue.createAnimatablePathOrSplitDimensionPath(reader, composition);
                        continue block20;
                    }
                    case "s": {
                        scale = AnimatableScaleValue.Factory.newInstance(reader, composition);
                        continue block20;
                    }
                    case "rz": {
                        composition.addWarning("Lottie doesn't support 3D layers.");
                    }
                    case "r": {
                        rotation = AnimatableFloatValue.Factory.newInstance(reader, composition, false);
                        continue block20;
                    }
                    case "o": {
                        opacity = AnimatableIntegerValue.Factory.newInstance(reader, composition);
                        continue block20;
                    }
                    case "so": {
                        startOpacity = AnimatableFloatValue.Factory.newInstance(reader, composition, false);
                        continue block20;
                    }
                    case "eo": {
                        endOpacity = AnimatableFloatValue.Factory.newInstance(reader, composition, false);
                        continue block20;
                    }
                }
                reader.skipValue();
            }
            if (isObject) {
                reader.endObject();
            }
            if (anchorPoint == null) {
                Log.w((String)"LOTTIE", (String)"Layer has no transform property. You may be using an unsupported layer type such as a camera.");
                anchorPoint = new AnimatablePathValue();
            }
            if (scale == null) {
                scale = new AnimatableScaleValue(new ScaleXY(1.0f, 1.0f));
            }
            if (opacity == null) {
                opacity = new AnimatableIntegerValue(100);
            }
            return new AnimatableTransform(anchorPoint, position, scale, rotation, opacity, startOpacity, endOpacity);
        }
    }
}

