/*
 * Decompiled with CFR 0.152.
 */
package com.airbnb.lottie.model.animatable;

import android.graphics.PointF;
import android.util.JsonReader;
import android.util.JsonToken;
import com.airbnb.lottie.LottieComposition;
import com.airbnb.lottie.animation.Keyframe;
import com.airbnb.lottie.animation.keyframe.BaseKeyframeAnimation;
import com.airbnb.lottie.animation.keyframe.PathKeyframe;
import com.airbnb.lottie.animation.keyframe.PathKeyframeAnimation;
import com.airbnb.lottie.animation.keyframe.PointKeyframeAnimation;
import com.airbnb.lottie.model.animatable.AnimatableFloatValue;
import com.airbnb.lottie.model.animatable.AnimatableSplitDimensionPathValue;
import com.airbnb.lottie.model.animatable.AnimatableValue;
import com.airbnb.lottie.utils.JsonUtils;
import com.airbnb.lottie.utils.Utils;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class AnimatablePathValue
implements AnimatableValue<PointF, PointF> {
    private final List<Keyframe<PointF>> keyframes = new ArrayList<Keyframe<PointF>>();

    public static AnimatableValue<PointF, PointF> createAnimatablePathOrSplitDimensionPath(JsonReader reader, LottieComposition composition) throws IOException {
        AnimatablePathValue pathAnimation = null;
        AnimatableFloatValue xAnimation = null;
        AnimatableFloatValue yAnimation = null;
        boolean hasExpressions = false;
        reader.beginObject();
        block10: while (reader.peek() != JsonToken.END_OBJECT) {
            switch (reader.nextName()) {
                case "k": {
                    pathAnimation = new AnimatablePathValue(reader, composition);
                    continue block10;
                }
                case "x": {
                    if (reader.peek() == JsonToken.STRING) {
                        hasExpressions = true;
                        reader.skipValue();
                        continue block10;
                    }
                    xAnimation = AnimatableFloatValue.Factory.newInstance(reader, composition);
                    continue block10;
                }
                case "y": {
                    if (reader.peek() == JsonToken.STRING) {
                        hasExpressions = true;
                        reader.skipValue();
                        continue block10;
                    }
                    yAnimation = AnimatableFloatValue.Factory.newInstance(reader, composition);
                    continue block10;
                }
            }
            reader.skipValue();
        }
        reader.endObject();
        if (hasExpressions) {
            composition.addWarning("Lottie doesn't support expressions.");
        }
        if (pathAnimation != null) {
            return pathAnimation;
        }
        return new AnimatableSplitDimensionPathValue(xAnimation, yAnimation);
    }

    AnimatablePathValue() {
        this.keyframes.add(new Keyframe<PointF>(new PointF(0.0f, 0.0f)));
    }

    AnimatablePathValue(JsonReader reader, LottieComposition composition) throws IOException {
        if (reader.peek() == JsonToken.BEGIN_ARRAY) {
            reader.beginArray();
            while (reader.hasNext()) {
                PathKeyframe keyframe = PathKeyframe.Factory.newInstance(reader, composition, ValueFactory.INSTANCE);
                this.keyframes.add(keyframe);
            }
            reader.endArray();
            Keyframe.setEndFrames(this.keyframes);
        } else {
            this.keyframes.add(new Keyframe<PointF>(JsonUtils.jsonToPoint(reader, Utils.dpScale())));
        }
    }

    @Override
    public BaseKeyframeAnimation<PointF, PointF> createAnimation() {
        if (this.keyframes.get(0).isStatic()) {
            return new PointKeyframeAnimation(this.keyframes);
        }
        return new PathKeyframeAnimation((List<? extends Keyframe<PointF>>)this.keyframes);
    }

    private static class ValueFactory
    implements AnimatableValue.Factory<PointF> {
        private static final AnimatableValue.Factory<PointF> INSTANCE = new ValueFactory();

        private ValueFactory() {
        }

        @Override
        public PointF valueFromObject(JsonReader reader, float scale) throws IOException {
            return JsonUtils.jsonToPoint(reader, scale);
        }
    }
}

