/*
 * Decompiled with CFR 0.152.
 */
package com.airbnb.lottie.model.animatable;

import android.graphics.Color;
import android.support.annotation.IntRange;
import android.util.JsonReader;
import android.util.JsonToken;
import android.util.Log;
import com.airbnb.lottie.LottieComposition;
import com.airbnb.lottie.animation.Keyframe;
import com.airbnb.lottie.animation.keyframe.BaseKeyframeAnimation;
import com.airbnb.lottie.animation.keyframe.GradientColorKeyframeAnimation;
import com.airbnb.lottie.model.animatable.AnimatableValue;
import com.airbnb.lottie.model.animatable.AnimatableValueParser;
import com.airbnb.lottie.model.animatable.BaseAnimatableValue;
import com.airbnb.lottie.model.content.GradientColor;
import com.airbnb.lottie.utils.MiscUtils;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class AnimatableGradientColorValue
extends BaseAnimatableValue<GradientColor, GradientColor> {
    private AnimatableGradientColorValue(List<Keyframe<GradientColor>> keyframes) {
        super(keyframes);
    }

    @Override
    public BaseKeyframeAnimation<GradientColor, GradientColor> createAnimation() {
        return new GradientColorKeyframeAnimation(this.keyframes);
    }

    private static class ValueFactory
    implements AnimatableValue.Factory<GradientColor> {
        private int colorPoints;

        private ValueFactory(int colorPoints) {
            this.colorPoints = colorPoints;
        }

        @Override
        public GradientColor valueFromObject(JsonReader reader, float scale) throws IOException {
            boolean isArray;
            ArrayList<Float> array = new ArrayList<Float>();
            boolean bl = isArray = reader.peek() == JsonToken.BEGIN_ARRAY;
            if (isArray) {
                reader.beginArray();
            }
            while (reader.hasNext()) {
                array.add(Float.valueOf((float)reader.nextDouble()));
            }
            if (isArray) {
                reader.endArray();
            }
            if (this.colorPoints == -1) {
                this.colorPoints = array.size() / 4;
            }
            float[] positions = new float[this.colorPoints];
            int[] colors = new int[this.colorPoints];
            int r = 0;
            int g = 0;
            if (array.size() != this.colorPoints * 4) {
                Log.w((String)"LOTTIE", (String)("Unexpected gradient length: " + array.size() + ". Expected " + this.colorPoints * 4 + ". This may affect the appearance of the gradient. Make sure to save your After Effects file before exporting an animation with gradients."));
            }
            block7: for (int i = 0; i < this.colorPoints * 4; ++i) {
                int colorIndex = i / 4;
                double value = ((Float)array.get(i)).floatValue();
                switch (i % 4) {
                    case 0: {
                        positions[colorIndex] = (float)value;
                        continue block7;
                    }
                    case 1: {
                        r = (int)(value * 255.0);
                        continue block7;
                    }
                    case 2: {
                        g = (int)(value * 255.0);
                        continue block7;
                    }
                    case 3: {
                        int b = (int)(value * 255.0);
                        colors[colorIndex] = Color.argb((int)255, (int)r, (int)g, (int)b);
                    }
                }
            }
            GradientColor gradientColor = new GradientColor(positions, colors);
            this.addOpacityStopsToGradientIfNeeded(gradientColor, array);
            return gradientColor;
        }

        private void addOpacityStopsToGradientIfNeeded(GradientColor gradientColor, List<Float> array) {
            int i;
            int startIndex = this.colorPoints * 4;
            if (array.size() <= startIndex) {
                return;
            }
            int opacityStops = (array.size() - startIndex) / 2;
            double[] positions = new double[opacityStops];
            double[] opacities = new double[opacityStops];
            int j = 0;
            for (i = startIndex; i < array.size(); ++i) {
                if (i % 2 == 0) {
                    positions[j] = array.get(i).floatValue();
                    continue;
                }
                opacities[j] = array.get(i).floatValue();
                ++j;
            }
            for (i = 0; i < gradientColor.getSize(); ++i) {
                int color = gradientColor.getColors()[i];
                gradientColor.getColors()[i] = color = Color.argb((int)this.getOpacityAtPosition(gradientColor.getPositions()[i], positions, opacities), (int)Color.red((int)color), (int)Color.green((int)color), (int)Color.blue((int)color));
            }
        }

        @IntRange(from=0L, to=255L)
        private int getOpacityAtPosition(double position, double[] positions, double[] opacities) {
            for (int i = 1; i < positions.length; ++i) {
                double lastPosition = positions[i - 1];
                double thisPosition = positions[i];
                if (!(positions[i] >= position)) continue;
                double progress = (position - lastPosition) / (thisPosition - lastPosition);
                return (int)(255.0 * MiscUtils.lerp(opacities[i - 1], opacities[i], progress));
            }
            return (int)(255.0 * opacities[opacities.length - 1]);
        }
    }

    public static final class Factory {
        private Factory() {
        }

        public static AnimatableGradientColorValue newInstance(JsonReader reader, LottieComposition composition, int points) throws IOException {
            return new AnimatableGradientColorValue(AnimatableValueParser.newInstance(reader, 1.0f, composition, new ValueFactory(points)));
        }
    }
}

