/*
 * Decompiled with CFR 0.152.
 */
package com.airbnb.lottie.model;

import android.util.JsonReader;
import com.airbnb.lottie.LottieComposition;
import com.airbnb.lottie.model.content.ShapeGroup;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class FontCharacter {
    private final List<ShapeGroup> shapes;
    private final char character;
    private final int size;
    private final double width;
    private final String style;
    private final String fontFamily;

    public static int hashFor(char character, String fontFamily, String style) {
        int result = 0;
        result = 31 * result + character;
        result = 31 * result + fontFamily.hashCode();
        result = 31 * result + style.hashCode();
        return result;
    }

    FontCharacter(List<ShapeGroup> shapes, char character, int size, double width, String style, String fontFamily) {
        this.shapes = shapes;
        this.character = character;
        this.size = size;
        this.width = width;
        this.style = style;
        this.fontFamily = fontFamily;
    }

    public List<ShapeGroup> getShapes() {
        return this.shapes;
    }

    int getSize() {
        return this.size;
    }

    public double getWidth() {
        return this.width;
    }

    String getStyle() {
        return this.style;
    }

    public int hashCode() {
        return FontCharacter.hashFor(this.character, this.fontFamily, this.style);
    }

    public static class Factory {
        public static FontCharacter newInstance(JsonReader reader, LottieComposition composition) throws IOException {
            char character = '\u0000';
            int size = 0;
            double width = 0.0;
            String style = null;
            String fontFamily = null;
            ArrayList<ShapeGroup> shapes = new ArrayList<ShapeGroup>();
            reader.beginObject();
            block16: while (reader.hasNext()) {
                switch (reader.nextName()) {
                    case "ch": {
                        character = reader.nextString().charAt(0);
                        continue block16;
                    }
                    case "size": {
                        size = reader.nextInt();
                        continue block16;
                    }
                    case "w": {
                        width = reader.nextDouble();
                        continue block16;
                    }
                    case "style": {
                        style = reader.nextString();
                        continue block16;
                    }
                    case "fFamily": {
                        fontFamily = reader.nextString();
                        continue block16;
                    }
                    case "data": {
                        reader.beginObject();
                        while (reader.hasNext()) {
                            if ("shapes".equals(reader.nextName())) {
                                reader.beginArray();
                                while (reader.hasNext()) {
                                    shapes.add((ShapeGroup)ShapeGroup.shapeItemWithJson(reader, composition));
                                }
                                reader.endArray();
                                continue;
                            }
                            reader.skipValue();
                        }
                        reader.endObject();
                        continue block16;
                    }
                }
                reader.skipValue();
            }
            reader.endObject();
            return new FontCharacter(shapes, character, size, width, style, fontFamily);
        }
    }
}

