/*
 * Decompiled with CFR 0.152.
 */
package com.airbnb.lottie.model;

import android.util.JsonReader;
import java.io.IOException;

public class Font {
    private final String family;
    private final String name;
    private final String style;
    private final float ascent;

    Font(String family, String name, String style, float ascent) {
        this.family = family;
        this.name = name;
        this.style = style;
        this.ascent = ascent;
    }

    public String getFamily() {
        return this.family;
    }

    public String getName() {
        return this.name;
    }

    public String getStyle() {
        return this.style;
    }

    float getAscent() {
        return this.ascent;
    }

    public static class Factory {
        public static Font newInstance(JsonReader reader) throws IOException {
            String family = null;
            String name = null;
            String style = null;
            float ascent = 0.0f;
            reader.beginObject();
            block12: while (reader.hasNext()) {
                switch (reader.nextName()) {
                    case "fFamily": {
                        family = reader.nextString();
                        continue block12;
                    }
                    case "fName": {
                        name = reader.nextString();
                        continue block12;
                    }
                    case "fStyle": {
                        style = reader.nextString();
                        continue block12;
                    }
                    case "ascent": {
                        ascent = (float)reader.nextDouble();
                        continue block12;
                    }
                }
                reader.skipValue();
            }
            reader.endObject();
            return new Font(family, name, style, ascent);
        }
    }
}

