/*
 * Decompiled with CFR 0.152.
 */
package com.airbnb.lottie.animation.keyframe;

import android.graphics.Path;
import android.graphics.PointF;
import android.support.annotation.Nullable;
import android.util.JsonReader;
import android.util.JsonToken;
import com.airbnb.lottie.LottieComposition;
import com.airbnb.lottie.animation.Keyframe;
import com.airbnb.lottie.model.animatable.AnimatableValue;
import com.airbnb.lottie.utils.Utils;
import java.io.IOException;

public class PathKeyframe
extends Keyframe<PointF> {
    @Nullable
    private Path path;

    private PathKeyframe(LottieComposition composition, Keyframe<PointF> keyframe) {
        super(composition, keyframe.startValue, keyframe.endValue, keyframe.interpolator, keyframe.startFrame, keyframe.endFrame);
        boolean equals;
        boolean bl = equals = this.endValue != null && this.startValue != null && ((PointF)this.startValue).equals(((PointF)this.endValue).x, ((PointF)this.endValue).y);
        if (this.endValue != null && !equals) {
            this.path = Utils.createPath((PointF)this.startValue, (PointF)this.endValue, keyframe.pathCp1, keyframe.pathCp2);
        }
    }

    @Nullable
    Path getPath() {
        return this.path;
    }

    public static class Factory {
        private Factory() {
        }

        public static PathKeyframe newInstance(JsonReader reader, LottieComposition composition, AnimatableValue.Factory<PointF> valueFactory) throws IOException {
            boolean animated = reader.peek() == JsonToken.BEGIN_OBJECT;
            Keyframe<PointF> keyframe = Keyframe.Factory.newInstance(reader, composition, Utils.dpScale(), valueFactory, animated);
            return new PathKeyframe(composition, keyframe);
        }
    }
}

