/*
 * Decompiled with CFR 0.152.
 */
package com.airbnb.lottie.animation;

import android.graphics.PointF;
import android.support.annotation.FloatRange;
import android.support.annotation.Nullable;
import android.support.v4.util.SparseArrayCompat;
import android.support.v4.view.animation.PathInterpolatorCompat;
import android.util.JsonReader;
import android.util.JsonToken;
import android.view.animation.Interpolator;
import android.view.animation.LinearInterpolator;
import com.airbnb.lottie.LottieComposition;
import com.airbnb.lottie.model.animatable.AnimatableValue;
import com.airbnb.lottie.utils.JsonUtils;
import com.airbnb.lottie.utils.MiscUtils;
import com.airbnb.lottie.utils.Utils;
import java.io.IOException;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.List;

public class Keyframe<T> {
    private static final float MAX_CP_VALUE = 100.0f;
    private static final Interpolator LINEAR_INTERPOLATOR = new LinearInterpolator();
    @Nullable
    private final LottieComposition composition;
    @Nullable
    public final T startValue;
    @Nullable
    public final T endValue;
    @Nullable
    public final Interpolator interpolator;
    public final float startFrame;
    @Nullable
    public Float endFrame;
    private float startProgress = Float.MIN_VALUE;
    private float endProgress = Float.MIN_VALUE;
    public PointF pathCp1 = null;
    public PointF pathCp2 = null;

    public static void setEndFrames(List<? extends Keyframe<?>> keyframes) {
        int size = keyframes.size();
        for (int i = 0; i < size - 1; ++i) {
            keyframes.get((int)i).endFrame = Float.valueOf(keyframes.get((int)(i + 1)).startFrame);
        }
        Keyframe<?> lastKeyframe = keyframes.get(size - 1);
        if (lastKeyframe.startValue == null) {
            keyframes.remove(lastKeyframe);
        }
    }

    public Keyframe(LottieComposition composition, @Nullable T startValue, @Nullable T endValue, @Nullable Interpolator interpolator, float startFrame, @Nullable Float endFrame) {
        this.composition = composition;
        this.startValue = startValue;
        this.endValue = endValue;
        this.interpolator = interpolator;
        this.startFrame = startFrame;
        this.endFrame = endFrame;
    }

    public Keyframe(T value) {
        this.composition = null;
        this.startValue = value;
        this.endValue = value;
        this.interpolator = null;
        this.startFrame = Float.MIN_VALUE;
        this.endFrame = Float.valueOf(Float.MAX_VALUE);
    }

    public float getStartProgress() {
        if (this.composition == null) {
            return 0.0f;
        }
        if (this.startProgress == Float.MIN_VALUE) {
            this.startProgress = (this.startFrame - this.composition.getStartFrame()) / this.composition.getDurationFrames();
        }
        return this.startProgress;
    }

    public float getEndProgress() {
        if (this.composition == null) {
            return 1.0f;
        }
        if (this.endProgress == Float.MIN_VALUE) {
            if (this.endFrame == null) {
                this.endProgress = 1.0f;
            } else {
                float startProgress = this.getStartProgress();
                float durationFrames = this.endFrame.floatValue() - this.startFrame;
                float durationProgress = durationFrames / this.composition.getDurationFrames();
                this.endProgress = startProgress + durationProgress;
            }
        }
        return this.endProgress;
    }

    public boolean isStatic() {
        return this.interpolator == null;
    }

    public boolean containsProgress(@FloatRange(from=0.0, to=1.0) float progress) {
        return progress >= this.getStartProgress() && progress < this.getEndProgress();
    }

    public String toString() {
        return "Keyframe{startValue=" + this.startValue + ", endValue=" + this.endValue + ", startFrame=" + this.startFrame + ", endFrame=" + this.endFrame + ", interpolator=" + this.interpolator + '}';
    }

    public static class Factory {
        private static SparseArrayCompat<WeakReference<Interpolator>> pathInterpolatorCache;

        private static SparseArrayCompat<WeakReference<Interpolator>> pathInterpolatorCache() {
            if (pathInterpolatorCache == null) {
                pathInterpolatorCache = new SparseArrayCompat();
            }
            return pathInterpolatorCache;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Nullable
        private static WeakReference<Interpolator> getInterpolator(int hash) {
            Class<Factory> clazz = Factory.class;
            synchronized (Factory.class) {
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return (WeakReference)Factory.pathInterpolatorCache().get(hash);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private static void putInterpolator(int hash, WeakReference<Interpolator> interpolator) {
            Class<Factory> clazz = Factory.class;
            synchronized (Factory.class) {
                pathInterpolatorCache.put(hash, interpolator);
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return;
            }
        }

        private Factory() {
        }

        public static <T> Keyframe<T> newInstance(JsonReader reader, LottieComposition composition, float scale, AnimatableValue.Factory<T> valueFactory, boolean animated) throws IOException {
            if (animated) {
                return Factory.parseKeyframe(composition, reader, scale, valueFactory);
            }
            return Factory.parseStaticValue(reader, scale, valueFactory);
        }

        private static <T> Keyframe<T> parseKeyframe(LottieComposition composition, JsonReader reader, float scale, AnimatableValue.Factory<T> valueFactory) throws IOException {
            PointF cp1 = null;
            PointF cp2 = null;
            float startFrame = 0.0f;
            Object startValue = null;
            Object endValue = null;
            boolean hold = false;
            Interpolator interpolator = null;
            PointF pathCp1 = null;
            PointF pathCp2 = null;
            reader.beginObject();
            block22: while (reader.hasNext()) {
                switch (reader.nextName()) {
                    case "t": {
                        startFrame = (float)reader.nextDouble();
                        continue block22;
                    }
                    case "s": {
                        startValue = valueFactory.valueFromObject(reader, scale);
                        continue block22;
                    }
                    case "e": {
                        endValue = valueFactory.valueFromObject(reader, scale);
                        continue block22;
                    }
                    case "o": {
                        cp1 = JsonUtils.jsonToPoint(reader, scale);
                        continue block22;
                    }
                    case "i": {
                        cp2 = JsonUtils.jsonToPoint(reader, scale);
                        continue block22;
                    }
                    case "h": {
                        hold = reader.nextInt() == 1;
                        continue block22;
                    }
                    case "to": {
                        pathCp1 = JsonUtils.jsonToPoint(reader, scale);
                        continue block22;
                    }
                    case "ti": {
                        pathCp2 = JsonUtils.jsonToPoint(reader, scale);
                        continue block22;
                    }
                }
                reader.skipValue();
            }
            reader.endObject();
            if (hold) {
                endValue = startValue;
                interpolator = LINEAR_INTERPOLATOR;
            } else if (cp1 != null && cp2 != null) {
                cp1.x = MiscUtils.clamp(cp1.x, -scale, scale);
                cp1.y = MiscUtils.clamp(cp1.y, -100.0f, 100.0f);
                cp2.x = MiscUtils.clamp(cp2.x, -scale, scale);
                cp2.y = MiscUtils.clamp(cp2.y, -100.0f, 100.0f);
                int hash = Utils.hashFor(cp1.x, cp1.y, cp2.x, cp2.y);
                WeakReference<Interpolator> interpolatorRef = Factory.getInterpolator(hash);
                if (interpolatorRef != null) {
                    interpolator = (Interpolator)interpolatorRef.get();
                }
                if (interpolatorRef == null || interpolator == null) {
                    interpolator = PathInterpolatorCompat.create((float)(cp1.x / scale), (float)(cp1.y / scale), (float)(cp2.x / scale), (float)(cp2.y / scale));
                    try {
                        Factory.putInterpolator(hash, new WeakReference<Interpolator>(interpolator));
                    }
                    catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {}
                }
            } else {
                interpolator = LINEAR_INTERPOLATOR;
            }
            Keyframe<Object> keyframe = new Keyframe<Object>(composition, startValue, endValue, interpolator, startFrame, null);
            keyframe.pathCp1 = pathCp1;
            keyframe.pathCp2 = pathCp2;
            return keyframe;
        }

        private static <T> Keyframe<T> parseStaticValue(JsonReader reader, float scale, AnimatableValue.Factory<T> valueFactory) throws IOException {
            T value = valueFactory.valueFromObject(reader, scale);
            return new Keyframe<T>(value);
        }

        public static <T> List<Keyframe<T>> parseKeyframes(JsonReader reader, LottieComposition composition, float scale, AnimatableValue.Factory<T> valueFactory) throws IOException {
            ArrayList<Keyframe<T>> keyframes = new ArrayList<Keyframe<T>>();
            if (reader.peek() == JsonToken.STRING) {
                composition.addWarning("Lottie doesn't support expressions.");
                return keyframes;
            }
            reader.beginObject();
            block6: while (reader.hasNext()) {
                switch (reader.nextName()) {
                    case "k": {
                        if (reader.peek() == JsonToken.BEGIN_ARRAY) {
                            reader.beginArray();
                            if (reader.peek() == JsonToken.NUMBER) {
                                keyframes.add(Factory.newInstance(reader, composition, scale, valueFactory, false));
                            } else {
                                while (reader.hasNext()) {
                                    keyframes.add(Factory.newInstance(reader, composition, scale, valueFactory, true));
                                }
                            }
                            reader.endArray();
                            continue block6;
                        }
                        keyframes.add(Factory.newInstance(reader, composition, scale, valueFactory, false));
                        continue block6;
                    }
                }
                reader.skipValue();
            }
            reader.endObject();
            Keyframe.setEndFrames(keyframes);
            return keyframes;
        }
    }
}

