/*
 * Decompiled with CFR 0.152.
 */
package com.airbnb.lottie;

import android.graphics.Rect;
import android.support.v4.util.LongSparseArray;
import android.util.JsonReader;
import com.airbnb.lottie.LottieComposition;
import com.airbnb.lottie.LottieImageAsset;
import com.airbnb.lottie.model.Font;
import com.airbnb.lottie.model.FontCharacter;
import com.airbnb.lottie.model.layer.Layer;
import com.airbnb.lottie.utils.Utils;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class LottieCompositionParser {
    public static LottieComposition parse(JsonReader reader) throws IOException {
        float scale = Utils.dpScale();
        int width = -1;
        LottieComposition composition = new LottieComposition();
        reader.beginObject();
        block24: while (reader.hasNext()) {
            switch (reader.nextName()) {
                case "w": {
                    width = reader.nextInt();
                    continue block24;
                }
                case "h": {
                    int height = reader.nextInt();
                    int scaledWidth = (int)((float)width * scale);
                    int scaledHeight = (int)((float)height * scale);
                    composition.bounds = new Rect(0, 0, scaledWidth, scaledHeight);
                    continue block24;
                }
                case "ip": {
                    composition.startFrame = (float)reader.nextDouble();
                    continue block24;
                }
                case "op": {
                    composition.endFrame = (float)reader.nextDouble();
                    continue block24;
                }
                case "fr": {
                    composition.frameRate = (float)reader.nextDouble();
                    continue block24;
                }
                case "v": {
                    String version = reader.nextString();
                    String[] versions = version.split("\\.");
                    composition.majorVersion = Integer.parseInt(versions[0]);
                    composition.minorVersion = Integer.parseInt(versions[1]);
                    composition.patchVersion = Integer.parseInt(versions[2]);
                    if (Utils.isAtLeastVersion(composition, 4, 5, 0)) continue block24;
                    composition.addWarning("Lottie only supports bodymovin >= 4.5.0");
                    continue block24;
                }
                case "layers": {
                    LottieCompositionParser.parseLayers(reader, composition);
                    continue block24;
                }
                case "assets": {
                    LottieCompositionParser.parseAssets(reader, composition);
                    continue block24;
                }
                case "fonts": {
                    LottieCompositionParser.parseFonts(reader, composition);
                    continue block24;
                }
                case "chars": {
                    LottieCompositionParser.parseChars(reader, composition);
                    continue block24;
                }
            }
            reader.skipValue();
        }
        reader.endObject();
        return composition;
    }

    private static void parseLayers(JsonReader reader, LottieComposition composition) throws IOException {
        int imageCount = 0;
        reader.beginArray();
        while (reader.hasNext()) {
            Layer layer = Layer.Factory.newInstance(reader, composition);
            if (layer.getLayerType() == Layer.LayerType.Image) {
                ++imageCount;
            }
            LottieCompositionParser.addLayer(composition.layers, composition.layerMap, layer);
            if (imageCount <= 4) continue;
            composition.warnings.add("You have " + imageCount + " images. Lottie should primarily be used with shapes. If you are using Adobe Illustrator, convert the Illustrator layers to shape layers.");
        }
        reader.endArray();
    }

    private static void parseAssets(JsonReader reader, LottieComposition composition) throws IOException {
        reader.beginArray();
        while (reader.hasNext()) {
            String id = null;
            ArrayList<Layer> layers = new ArrayList<Layer>();
            LongSparseArray layerMap = new LongSparseArray();
            int width = 0;
            int height = 0;
            String imageFileName = null;
            String relativeFolder = null;
            reader.beginObject();
            block17: while (reader.hasNext()) {
                switch (reader.nextName()) {
                    case "id": {
                        id = reader.nextString();
                        continue block17;
                    }
                    case "layers": {
                        reader.beginArray();
                        while (reader.hasNext()) {
                            Layer layer = Layer.Factory.newInstance(reader, composition);
                            layerMap.put(layer.getId(), (Object)layer);
                            layers.add(layer);
                        }
                        reader.endArray();
                        continue block17;
                    }
                    case "w": {
                        width = reader.nextInt();
                        continue block17;
                    }
                    case "h": {
                        height = reader.nextInt();
                        continue block17;
                    }
                    case "p": {
                        imageFileName = reader.nextString();
                        continue block17;
                    }
                    case "u": {
                        relativeFolder = reader.nextString();
                        continue block17;
                    }
                }
                reader.skipValue();
            }
            reader.endObject();
            if (!layers.isEmpty()) {
                composition.precomps.put(id, layers);
                continue;
            }
            if (imageFileName == null) continue;
            LottieImageAsset image = new LottieImageAsset(width, height, id, imageFileName, relativeFolder);
            composition.images.put(image.getId(), image);
        }
        reader.endArray();
    }

    private static void parseFonts(JsonReader reader, LottieComposition composition) throws IOException {
        reader.beginObject();
        block6: while (reader.hasNext()) {
            switch (reader.nextName()) {
                case "list": {
                    reader.beginArray();
                    while (reader.hasNext()) {
                        Font font = Font.Factory.newInstance(reader);
                        composition.fonts.put(font.getName(), font);
                    }
                    reader.endArray();
                    continue block6;
                }
            }
            reader.skipValue();
        }
        reader.endObject();
    }

    private static void parseChars(JsonReader reader, LottieComposition composition) throws IOException {
        reader.beginArray();
        while (reader.hasNext()) {
            FontCharacter character = FontCharacter.Factory.newInstance(reader, composition);
            composition.characters.put(character.hashCode(), (Object)character);
        }
        reader.endArray();
    }

    private static void addLayer(List<Layer> layers, LongSparseArray<Layer> layerMap, Layer layer) {
        layers.add(layer);
        layerMap.put(layer.getId(), (Object)layer);
    }
}

