/*
 * Decompiled with CFR 0.152.
 */
package com.airbnb.lottie;

import android.content.Context;
import android.graphics.Rect;
import android.os.AsyncTask;
import android.support.annotation.Nullable;
import android.support.annotation.RawRes;
import android.support.annotation.RestrictTo;
import android.support.v4.util.LongSparseArray;
import android.support.v4.util.SparseArrayCompat;
import android.util.JsonReader;
import android.util.Log;
import com.airbnb.lottie.Cancellable;
import com.airbnb.lottie.LottieCompositionParser;
import com.airbnb.lottie.LottieImageAsset;
import com.airbnb.lottie.OnCompositionLoadedListener;
import com.airbnb.lottie.PerformanceTracker;
import com.airbnb.lottie.model.Font;
import com.airbnb.lottie.model.FontCharacter;
import com.airbnb.lottie.model.JsonCompositionLoader;
import com.airbnb.lottie.model.layer.Layer;
import com.airbnb.lottie.utils.Utils;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;

public class LottieComposition {
    private final PerformanceTracker performanceTracker = new PerformanceTracker();
    final Map<String, List<Layer>> precomps = new HashMap<String, List<Layer>>();
    final Map<String, LottieImageAsset> images = new HashMap<String, LottieImageAsset>();
    final Map<String, Font> fonts = new HashMap<String, Font>();
    final SparseArrayCompat<FontCharacter> characters = new SparseArrayCompat();
    final LongSparseArray<Layer> layerMap = new LongSparseArray();
    final List<Layer> layers = new ArrayList<Layer>();
    final HashSet<String> warnings = new HashSet();
    Rect bounds;
    float startFrame;
    float endFrame;
    float frameRate;
    int majorVersion;
    int minorVersion;
    int patchVersion;

    @RestrictTo(value={RestrictTo.Scope.LIBRARY})
    public void addWarning(String warning) {
        Log.w((String)"LOTTIE", (String)warning);
        this.warnings.add(warning);
    }

    public ArrayList<String> getWarnings() {
        return new ArrayList<String>(Arrays.asList(this.warnings.toArray(new String[this.warnings.size()])));
    }

    public void setPerformanceTrackingEnabled(boolean enabled) {
        this.performanceTracker.setEnabled(enabled);
    }

    public PerformanceTracker getPerformanceTracker() {
        return this.performanceTracker;
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY})
    public Layer layerModelForId(long id) {
        return (Layer)this.layerMap.get(id);
    }

    public Rect getBounds() {
        return this.bounds;
    }

    public float getDuration() {
        float frameDuration = this.endFrame - this.startFrame;
        return (long)(frameDuration / this.frameRate * 1000.0f);
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY})
    public int getMajorVersion() {
        return this.majorVersion;
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY})
    public int getMinorVersion() {
        return this.minorVersion;
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY})
    public int getPatchVersion() {
        return this.patchVersion;
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY})
    public float getStartFrame() {
        return this.startFrame;
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY})
    public float getEndFrame() {
        return this.endFrame;
    }

    public List<Layer> getLayers() {
        return this.layers;
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY})
    @Nullable
    public List<Layer> getPrecomps(String id) {
        return this.precomps.get(id);
    }

    public SparseArrayCompat<FontCharacter> getCharacters() {
        return this.characters;
    }

    public Map<String, Font> getFonts() {
        return this.fonts;
    }

    public boolean hasImages() {
        return !this.images.isEmpty();
    }

    public Map<String, LottieImageAsset> getImages() {
        return this.images;
    }

    public float getDurationFrames() {
        return this.getDuration() * this.frameRate / 1000.0f;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("LottieComposition:\n");
        for (Layer layer : this.layers) {
            sb.append(layer.toString("\t"));
        }
        return sb.toString();
    }

    public static class Factory {
        private Factory() {
        }

        public static Cancellable fromAssetFileName(Context context, String fileName, OnCompositionLoadedListener listener) {
            InputStream stream;
            try {
                stream = context.getAssets().open(fileName);
            }
            catch (IOException e) {
                throw new IllegalArgumentException("Unable to find file " + fileName, e);
            }
            return Factory.fromInputStream(stream, listener);
        }

        public static Cancellable fromRawFile(Context context, @RawRes int resId, OnCompositionLoadedListener listener) {
            return Factory.fromInputStream(context.getResources().openRawResource(resId), listener);
        }

        public static Cancellable fromInputStream(InputStream stream, OnCompositionLoadedListener listener) {
            return Factory.fromJsonReader(new JsonReader((Reader)new InputStreamReader(stream)), listener);
        }

        public static Cancellable fromJsonString(String jsonString, OnCompositionLoadedListener listener) {
            return Factory.fromJsonReader(new JsonReader((Reader)new StringReader(jsonString)), listener);
        }

        public static Cancellable fromJsonReader(JsonReader reader, OnCompositionLoadedListener listener) {
            JsonCompositionLoader loader = new JsonCompositionLoader(listener);
            loader.executeOnExecutor(AsyncTask.THREAD_POOL_EXECUTOR, new JsonReader[]{reader});
            return loader;
        }

        @Nullable
        public static LottieComposition fromFileSync(Context context, String fileName) {
            try {
                return Factory.fromInputStreamSync(context.getAssets().open(fileName));
            }
            catch (IOException e) {
                throw new IllegalArgumentException("Unable to open asset " + fileName, e);
            }
        }

        @Nullable
        public static LottieComposition fromInputStreamSync(InputStream stream) {
            LottieComposition composition;
            try {
                composition = Factory.fromJsonSync(new JsonReader((Reader)new InputStreamReader(stream)));
            }
            catch (IOException e) {
                throw new IllegalArgumentException("Unable to parse composition.", e);
            }
            finally {
                Utils.closeQuietly(stream);
            }
            return composition;
        }

        public static LottieComposition fromJsonSync(JsonReader reader) throws IOException {
            return LottieCompositionParser.parse(reader);
        }
    }
}

