/*
 * Decompiled with CFR 0.152.
 */
package com.airbnb.lottie.model.content;

import android.graphics.Path;
import android.support.annotation.Nullable;
import android.util.JsonReader;
import com.airbnb.lottie.LottieComposition;
import com.airbnb.lottie.LottieDrawable;
import com.airbnb.lottie.animation.content.Content;
import com.airbnb.lottie.animation.content.FillContent;
import com.airbnb.lottie.model.animatable.AnimatableColorValue;
import com.airbnb.lottie.model.animatable.AnimatableIntegerValue;
import com.airbnb.lottie.model.content.ContentModel;
import com.airbnb.lottie.model.layer.BaseLayer;
import java.io.IOException;

public class ShapeFill
implements ContentModel {
    private final boolean fillEnabled;
    private final Path.FillType fillType;
    private final String name;
    @Nullable
    private final AnimatableColorValue color;
    @Nullable
    private final AnimatableIntegerValue opacity;

    private ShapeFill(String name, boolean fillEnabled, Path.FillType fillType, @Nullable AnimatableColorValue color, @Nullable AnimatableIntegerValue opacity) {
        this.name = name;
        this.fillEnabled = fillEnabled;
        this.fillType = fillType;
        this.color = color;
        this.opacity = opacity;
    }

    public String getName() {
        return this.name;
    }

    @Nullable
    public AnimatableColorValue getColor() {
        return this.color;
    }

    @Nullable
    public AnimatableIntegerValue getOpacity() {
        return this.opacity;
    }

    public Path.FillType getFillType() {
        return this.fillType;
    }

    @Override
    public Content toContent(LottieDrawable drawable, BaseLayer layer) {
        return new FillContent(drawable, layer, this);
    }

    public String toString() {
        return "ShapeFill{color=, fillEnabled=" + this.fillEnabled + '}';
    }

    static class Factory {
        private Factory() {
        }

        static ShapeFill newInstance(JsonReader reader, LottieComposition composition) throws IOException {
            AnimatableColorValue color = null;
            boolean fillEnabled = false;
            AnimatableIntegerValue opacity = null;
            String name = null;
            int fillTypeInt = 1;
            block14: while (reader.hasNext()) {
                switch (reader.nextName()) {
                    case "nm": {
                        name = reader.nextString();
                        continue block14;
                    }
                    case "c": {
                        color = AnimatableColorValue.Factory.newInstance(reader, composition);
                        continue block14;
                    }
                    case "o": {
                        opacity = AnimatableIntegerValue.Factory.newInstance(reader, composition);
                        continue block14;
                    }
                    case "fillEnabled": {
                        fillEnabled = reader.nextBoolean();
                        continue block14;
                    }
                    case "r": {
                        fillTypeInt = reader.nextInt();
                        continue block14;
                    }
                }
                reader.skipValue();
            }
            Path.FillType fillType = fillTypeInt == 1 ? Path.FillType.WINDING : Path.FillType.EVEN_ODD;
            return new ShapeFill(name, fillEnabled, fillType, color, opacity);
        }
    }
}

