/*
 * Decompiled with CFR 0.152.
 */
package com.airbnb.lottie.model.content;

import android.graphics.PointF;
import android.util.JsonReader;
import com.airbnb.lottie.LottieComposition;
import com.airbnb.lottie.LottieDrawable;
import com.airbnb.lottie.animation.content.Content;
import com.airbnb.lottie.animation.content.RectangleContent;
import com.airbnb.lottie.model.animatable.AnimatableFloatValue;
import com.airbnb.lottie.model.animatable.AnimatablePathValue;
import com.airbnb.lottie.model.animatable.AnimatablePointValue;
import com.airbnb.lottie.model.animatable.AnimatableValue;
import com.airbnb.lottie.model.content.ContentModel;
import com.airbnb.lottie.model.layer.BaseLayer;
import java.io.IOException;

public class RectangleShape
implements ContentModel {
    private final String name;
    private final AnimatableValue<PointF, PointF> position;
    private final AnimatablePointValue size;
    private final AnimatableFloatValue cornerRadius;

    private RectangleShape(String name, AnimatableValue<PointF, PointF> position, AnimatablePointValue size, AnimatableFloatValue cornerRadius) {
        this.name = name;
        this.position = position;
        this.size = size;
        this.cornerRadius = cornerRadius;
    }

    public String getName() {
        return this.name;
    }

    public AnimatableFloatValue getCornerRadius() {
        return this.cornerRadius;
    }

    public AnimatablePointValue getSize() {
        return this.size;
    }

    public AnimatableValue<PointF, PointF> getPosition() {
        return this.position;
    }

    @Override
    public Content toContent(LottieDrawable drawable, BaseLayer layer) {
        return new RectangleContent(drawable, layer, this);
    }

    public String toString() {
        return "RectangleShape{position=" + this.position + ", size=" + this.size + '}';
    }

    static class Factory {
        private Factory() {
        }

        static RectangleShape newInstance(JsonReader reader, LottieComposition composition) throws IOException {
            String name = null;
            AnimatableValue<PointF, PointF> position = null;
            AnimatablePointValue size = null;
            AnimatableFloatValue roundedness = null;
            block12: while (reader.hasNext()) {
                switch (reader.nextName()) {
                    case "nm": {
                        name = reader.nextString();
                        continue block12;
                    }
                    case "p": {
                        position = AnimatablePathValue.createAnimatablePathOrSplitDimensionPath(reader, composition);
                        continue block12;
                    }
                    case "s": {
                        size = AnimatablePointValue.Factory.newInstance(reader, composition);
                        continue block12;
                    }
                    case "r": {
                        roundedness = AnimatableFloatValue.Factory.newInstance(reader, composition);
                        continue block12;
                    }
                }
                reader.skipValue();
            }
            return new RectangleShape(name, position, size, roundedness);
        }
    }
}

