/*
 * Decompiled with CFR 0.152.
 */
package com.airbnb.lottie.model.content;

import android.support.annotation.Nullable;
import android.util.JsonReader;
import com.airbnb.lottie.LottieComposition;
import com.airbnb.lottie.LottieDrawable;
import com.airbnb.lottie.animation.content.Content;
import com.airbnb.lottie.animation.content.GradientStrokeContent;
import com.airbnb.lottie.model.animatable.AnimatableFloatValue;
import com.airbnb.lottie.model.animatable.AnimatableGradientColorValue;
import com.airbnb.lottie.model.animatable.AnimatableIntegerValue;
import com.airbnb.lottie.model.animatable.AnimatablePointValue;
import com.airbnb.lottie.model.content.ContentModel;
import com.airbnb.lottie.model.content.GradientType;
import com.airbnb.lottie.model.content.ShapeStroke;
import com.airbnb.lottie.model.layer.BaseLayer;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class GradientStroke
implements ContentModel {
    private final String name;
    private final GradientType gradientType;
    private final AnimatableGradientColorValue gradientColor;
    private final AnimatableIntegerValue opacity;
    private final AnimatablePointValue startPoint;
    private final AnimatablePointValue endPoint;
    private final AnimatableFloatValue width;
    private final ShapeStroke.LineCapType capType;
    private final ShapeStroke.LineJoinType joinType;
    private final List<AnimatableFloatValue> lineDashPattern;
    @Nullable
    private final AnimatableFloatValue dashOffset;

    private GradientStroke(String name, GradientType gradientType, AnimatableGradientColorValue gradientColor, AnimatableIntegerValue opacity, AnimatablePointValue startPoint, AnimatablePointValue endPoint, AnimatableFloatValue width, ShapeStroke.LineCapType capType, ShapeStroke.LineJoinType joinType, List<AnimatableFloatValue> lineDashPattern, @Nullable AnimatableFloatValue dashOffset) {
        this.name = name;
        this.gradientType = gradientType;
        this.gradientColor = gradientColor;
        this.opacity = opacity;
        this.startPoint = startPoint;
        this.endPoint = endPoint;
        this.width = width;
        this.capType = capType;
        this.joinType = joinType;
        this.lineDashPattern = lineDashPattern;
        this.dashOffset = dashOffset;
    }

    public String getName() {
        return this.name;
    }

    public GradientType getGradientType() {
        return this.gradientType;
    }

    public AnimatableGradientColorValue getGradientColor() {
        return this.gradientColor;
    }

    public AnimatableIntegerValue getOpacity() {
        return this.opacity;
    }

    public AnimatablePointValue getStartPoint() {
        return this.startPoint;
    }

    public AnimatablePointValue getEndPoint() {
        return this.endPoint;
    }

    public AnimatableFloatValue getWidth() {
        return this.width;
    }

    public ShapeStroke.LineCapType getCapType() {
        return this.capType;
    }

    public ShapeStroke.LineJoinType getJoinType() {
        return this.joinType;
    }

    public List<AnimatableFloatValue> getLineDashPattern() {
        return this.lineDashPattern;
    }

    @Nullable
    public AnimatableFloatValue getDashOffset() {
        return this.dashOffset;
    }

    @Override
    public Content toContent(LottieDrawable drawable, BaseLayer layer) {
        return new GradientStrokeContent(drawable, layer, this);
    }

    static class Factory {
        private Factory() {
        }

        static GradientStroke newInstance(JsonReader reader, LottieComposition composition) throws IOException {
            String name = null;
            AnimatableGradientColorValue color = null;
            AnimatableIntegerValue opacity = null;
            GradientType gradientType = null;
            AnimatablePointValue startPoint = null;
            AnimatablePointValue endPoint = null;
            AnimatableFloatValue width = null;
            ShapeStroke.LineCapType capType = null;
            ShapeStroke.LineJoinType joinType = null;
            AnimatableFloatValue offset = null;
            ArrayList<AnimatableFloatValue> lineDashPattern = new ArrayList<AnimatableFloatValue>();
            block40: while (reader.hasNext()) {
                switch (reader.nextName()) {
                    case "nm": {
                        name = reader.nextString();
                        continue block40;
                    }
                    case "g": {
                        int points = -1;
                        reader.beginObject();
                        block41: while (reader.hasNext()) {
                            switch (reader.nextName()) {
                                case "p": {
                                    points = reader.nextInt();
                                    continue block41;
                                }
                                case "k": {
                                    color = AnimatableGradientColorValue.Factory.newInstance(reader, composition, points);
                                    continue block41;
                                }
                            }
                            reader.skipValue();
                        }
                        reader.endObject();
                        continue block40;
                    }
                    case "o": {
                        opacity = AnimatableIntegerValue.Factory.newInstance(reader, composition);
                        continue block40;
                    }
                    case "t": {
                        gradientType = reader.nextInt() == 1 ? GradientType.Linear : GradientType.Radial;
                        continue block40;
                    }
                    case "s": {
                        startPoint = AnimatablePointValue.Factory.newInstance(reader, composition);
                        continue block40;
                    }
                    case "e": {
                        endPoint = AnimatablePointValue.Factory.newInstance(reader, composition);
                        continue block40;
                    }
                    case "w": {
                        width = AnimatableFloatValue.Factory.newInstance(reader, composition);
                        continue block40;
                    }
                    case "lc": {
                        capType = ShapeStroke.LineCapType.values()[reader.nextInt() - 1];
                        continue block40;
                    }
                    case "lj": {
                        joinType = ShapeStroke.LineJoinType.values()[reader.nextInt() - 1];
                        continue block40;
                    }
                    case "d": {
                        reader.beginArray();
                        while (reader.hasNext()) {
                            String n = null;
                            AnimatableFloatValue val = null;
                            reader.beginObject();
                            block43: while (reader.hasNext()) {
                                switch (reader.nextName()) {
                                    case "n": {
                                        n = reader.nextString();
                                        continue block43;
                                    }
                                    case "v": {
                                        val = AnimatableFloatValue.Factory.newInstance(reader, composition);
                                        continue block43;
                                    }
                                }
                                reader.skipValue();
                            }
                            reader.endObject();
                            if (n.equals("o")) {
                                offset = val;
                                continue;
                            }
                            if (!n.equals("d") && !n.equals("g")) continue;
                            lineDashPattern.add(val);
                        }
                        reader.endArray();
                        if (lineDashPattern.size() != 1) continue block40;
                        lineDashPattern.add((AnimatableFloatValue)lineDashPattern.get(0));
                        continue block40;
                    }
                }
                reader.skipValue();
            }
            return new GradientStroke(name, gradientType, color, opacity, startPoint, endPoint, width, capType, joinType, lineDashPattern, offset);
        }
    }
}

