/*
 * Decompiled with CFR 0.152.
 */
package com.airbnb.lottie;

import android.content.Context;
import android.content.res.Resources;
import android.graphics.Rect;
import android.os.AsyncTask;
import android.support.annotation.Nullable;
import android.support.annotation.RawRes;
import android.support.annotation.RestrictTo;
import android.support.v4.util.LongSparseArray;
import android.support.v4.util.SparseArrayCompat;
import android.util.JsonReader;
import android.util.Log;
import com.airbnb.lottie.Cancellable;
import com.airbnb.lottie.LottieImageAsset;
import com.airbnb.lottie.OnCompositionLoadedListener;
import com.airbnb.lottie.PerformanceTracker;
import com.airbnb.lottie.model.FileCompositionLoader;
import com.airbnb.lottie.model.Font;
import com.airbnb.lottie.model.FontCharacter;
import com.airbnb.lottie.model.JsonCompositionLoader;
import com.airbnb.lottie.model.layer.Layer;
import com.airbnb.lottie.utils.Utils;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.json.JSONObject;

public class LottieComposition {
    private final Map<String, List<Layer>> precomps = new HashMap<String, List<Layer>>();
    private final Map<String, LottieImageAsset> images = new HashMap<String, LottieImageAsset>();
    private final Map<String, Font> fonts = new HashMap<String, Font>();
    private final SparseArrayCompat<FontCharacter> characters = new SparseArrayCompat();
    private final LongSparseArray<Layer> layerMap = new LongSparseArray();
    private final List<Layer> layers = new ArrayList<Layer>();
    private final HashSet<String> warnings = new HashSet();
    private final PerformanceTracker performanceTracker = new PerformanceTracker();
    private Rect bounds;
    private float startFrame;
    private float endFrame;
    private float frameRate;
    private int majorVersion;
    private int minorVersion;
    private int patchVersion;

    @RestrictTo(value={RestrictTo.Scope.LIBRARY})
    public void addWarning(String warning) {
        Log.w((String)"LOTTIE", (String)warning);
        this.warnings.add(warning);
    }

    public ArrayList<String> getWarnings() {
        return new ArrayList<String>(Arrays.asList(this.warnings.toArray(new String[this.warnings.size()])));
    }

    public void setPerformanceTrackingEnabled(boolean enabled) {
        this.performanceTracker.setEnabled(enabled);
    }

    public PerformanceTracker getPerformanceTracker() {
        return this.performanceTracker;
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY})
    public Layer layerModelForId(long id) {
        return (Layer)this.layerMap.get(id);
    }

    public Rect getBounds() {
        return this.bounds;
    }

    public float getDuration() {
        float frameDuration = this.endFrame - this.startFrame;
        return (long)(frameDuration / this.frameRate * 1000.0f);
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY})
    public int getMajorVersion() {
        return this.majorVersion;
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY})
    public int getMinorVersion() {
        return this.minorVersion;
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY})
    public int getPatchVersion() {
        return this.patchVersion;
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY})
    public float getStartFrame() {
        return this.startFrame;
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY})
    public float getEndFrame() {
        return this.endFrame;
    }

    public List<Layer> getLayers() {
        return this.layers;
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY})
    @Nullable
    public List<Layer> getPrecomps(String id) {
        return this.precomps.get(id);
    }

    public SparseArrayCompat<FontCharacter> getCharacters() {
        return this.characters;
    }

    public Map<String, Font> getFonts() {
        return this.fonts;
    }

    public boolean hasImages() {
        return !this.images.isEmpty();
    }

    public Map<String, LottieImageAsset> getImages() {
        return this.images;
    }

    public float getDurationFrames() {
        return this.getDuration() * this.frameRate / 1000.0f;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("LottieComposition:\n");
        for (Layer layer : this.layers) {
            sb.append(layer.toString("\t"));
        }
        return sb.toString();
    }

    public static class Factory {
        private Factory() {
        }

        public static Cancellable fromAssetFileName(Context context, String fileName, OnCompositionLoadedListener loadedListener) {
            InputStream stream;
            try {
                stream = context.getAssets().open(fileName);
            }
            catch (IOException e) {
                throw new IllegalStateException("Unable to find file " + fileName, e);
            }
            return Factory.fromInputStream(context, stream, loadedListener);
        }

        public static Cancellable fromRawFile(Context context, @RawRes int resId, OnCompositionLoadedListener loadedListener) {
            return Factory.fromInputStream(context, context.getResources().openRawResource(resId), loadedListener);
        }

        public static Cancellable fromInputStream(Context context, InputStream stream, OnCompositionLoadedListener loadedListener) {
            FileCompositionLoader loader = new FileCompositionLoader(context.getResources(), loadedListener);
            loader.executeOnExecutor(AsyncTask.THREAD_POOL_EXECUTOR, new InputStream[]{stream});
            return loader;
        }

        public static LottieComposition fromFileSync(Context context, String fileName) {
            InputStream stream;
            try {
                stream = context.getAssets().open(fileName);
            }
            catch (IOException e) {
                throw new IllegalStateException("Unable to find file " + fileName, e);
            }
            return Factory.fromInputStream(context.getResources(), stream);
        }

        public static Cancellable fromJson(Resources res, JSONObject json, OnCompositionLoadedListener loadedListener) {
            JsonCompositionLoader loader = new JsonCompositionLoader(loadedListener);
            loader.executeOnExecutor(AsyncTask.THREAD_POOL_EXECUTOR, new JSONObject[]{json});
            return loader;
        }

        @Nullable
        public static LottieComposition fromInputStream(Resources res, InputStream stream) {
            try {
                LottieComposition lottieComposition = Factory.fromJsonSync(new JsonReader((Reader)new InputStreamReader(stream)));
                return lottieComposition;
            }
            catch (IOException e) {
                Log.e((String)"LOTTIE", (String)"Failed to load composition.", (Throwable)new IllegalStateException("Unable to find file.", e));
            }
            finally {
                Utils.closeQuietly(stream);
            }
            return null;
        }

        @Deprecated
        public static LottieComposition fromJsonSync(Resources res, JSONObject json) {
            try {
                return Factory.fromJsonSync(res, new JsonReader((Reader)new StringReader(json.toString())));
            }
            catch (IOException e) {
                throw new IllegalArgumentException("Unable to parse json", e);
            }
        }

        @Deprecated
        public static LottieComposition fromJsonSync(Resources res, JsonReader reader) throws IOException {
            return Factory.fromJsonSync(reader);
        }

        public static LottieComposition fromJsonSync(JsonReader reader) throws IOException {
            float scale = Utils.dpScale();
            int width = -1;
            LottieComposition composition = new LottieComposition();
            reader.beginObject();
            block24: while (reader.hasNext()) {
                switch (reader.nextName()) {
                    case "w": {
                        width = reader.nextInt();
                        continue block24;
                    }
                    case "h": {
                        int height = reader.nextInt();
                        int scaledWidth = (int)((float)width * scale);
                        int scaledHeight = (int)((float)height * scale);
                        composition.bounds = new Rect(0, 0, scaledWidth, scaledHeight);
                        continue block24;
                    }
                    case "ip": {
                        composition.startFrame = (float)reader.nextDouble();
                        continue block24;
                    }
                    case "op": {
                        composition.endFrame = (float)reader.nextDouble();
                        continue block24;
                    }
                    case "fr": {
                        composition.frameRate = (float)reader.nextDouble();
                        continue block24;
                    }
                    case "v": {
                        String version = reader.nextString();
                        String[] versions = version.split("\\.");
                        composition.majorVersion = Integer.parseInt(versions[0]);
                        composition.minorVersion = Integer.parseInt(versions[1]);
                        composition.patchVersion = Integer.parseInt(versions[2]);
                        if (Utils.isAtLeastVersion(composition, 4, 5, 0)) continue block24;
                        composition.addWarning("Lottie only supports bodymovin >= 4.5.0");
                        continue block24;
                    }
                    case "layers": {
                        Factory.parseLayers(reader, composition);
                        continue block24;
                    }
                    case "assets": {
                        Factory.parseAssets(reader, composition);
                        continue block24;
                    }
                    case "fonts": {
                        Factory.parseFonts(reader, composition);
                        continue block24;
                    }
                    case "chars": {
                        Factory.parseChars(reader, composition);
                        continue block24;
                    }
                }
                reader.skipValue();
            }
            reader.endObject();
            return composition;
        }

        private static void parseLayers(JsonReader reader, LottieComposition composition) throws IOException {
            int imageCount = 0;
            reader.beginArray();
            while (reader.hasNext()) {
                Layer layer = Layer.Factory.newInstance(reader, composition);
                if (layer.getLayerType() == Layer.LayerType.Image) {
                    ++imageCount;
                }
                Factory.addLayer(composition.layers, (LongSparseArray<Layer>)composition.layerMap, layer);
                if (imageCount <= 4) continue;
                composition.warnings.add("You have " + imageCount + " images. Lottie should primarily be used with shapes. If you are using Adobe Illustrator, convert the Illustrator layers to shape layers.");
            }
            reader.endArray();
        }

        private static void parseAssets(JsonReader reader, LottieComposition composition) throws IOException {
            reader.beginArray();
            while (reader.hasNext()) {
                String id = null;
                ArrayList<Layer> layers = new ArrayList<Layer>();
                LongSparseArray layerMap = new LongSparseArray();
                int width = 0;
                int height = 0;
                String imageFileName = null;
                String relativeFolder = null;
                reader.beginObject();
                block17: while (reader.hasNext()) {
                    switch (reader.nextName()) {
                        case "id": {
                            id = reader.nextString();
                            continue block17;
                        }
                        case "layers": {
                            reader.beginArray();
                            while (reader.hasNext()) {
                                Layer layer = Layer.Factory.newInstance(reader, composition);
                                layerMap.put(layer.getId(), (Object)layer);
                                layers.add(layer);
                            }
                            reader.endArray();
                            continue block17;
                        }
                        case "w": {
                            width = reader.nextInt();
                            continue block17;
                        }
                        case "h": {
                            height = reader.nextInt();
                            continue block17;
                        }
                        case "p": {
                            imageFileName = reader.nextString();
                            continue block17;
                        }
                        case "u": {
                            relativeFolder = reader.nextString();
                            continue block17;
                        }
                    }
                    reader.skipValue();
                }
                reader.endObject();
                if (!layers.isEmpty()) {
                    composition.precomps.put(id, layers);
                    continue;
                }
                if (imageFileName == null) continue;
                LottieImageAsset image = new LottieImageAsset(width, height, id, imageFileName, relativeFolder);
                composition.images.put(image.getId(), image);
            }
            reader.endArray();
        }

        private static void parseFonts(JsonReader reader, LottieComposition composition) throws IOException {
            reader.beginObject();
            block6: while (reader.hasNext()) {
                switch (reader.nextName()) {
                    case "list": {
                        reader.beginArray();
                        while (reader.hasNext()) {
                            Font font = Font.Factory.newInstance(reader);
                            composition.fonts.put(font.getName(), font);
                        }
                        reader.endArray();
                        continue block6;
                    }
                }
                reader.skipValue();
            }
            reader.endObject();
        }

        private static void parseChars(JsonReader reader, LottieComposition composition) throws IOException {
            reader.beginArray();
            while (reader.hasNext()) {
                FontCharacter character = FontCharacter.Factory.newInstance(reader, composition);
                composition.characters.put(character.hashCode(), (Object)character);
            }
            reader.endArray();
        }

        private static void addLayer(List<Layer> layers, LongSparseArray<Layer> layerMap, Layer layer) {
            layers.add(layer);
            layerMap.put(layer.getId(), (Object)layer);
        }
    }
}

