/*
 * Decompiled with CFR 0.152.
 */
package com.airbnb.lottie.utils;

import android.graphics.Path;
import android.graphics.PointF;
import android.support.annotation.FloatRange;
import com.airbnb.lottie.animation.content.KeyPathElementContent;
import com.airbnb.lottie.model.CubicCurveData;
import com.airbnb.lottie.model.KeyPath;
import com.airbnb.lottie.model.content.ShapeData;
import java.util.List;

public class MiscUtils {
    public static PointF addPoints(PointF p1, PointF p2) {
        return new PointF(p1.x + p2.x, p1.y + p2.y);
    }

    public static void getPathFromData(ShapeData shapeData, Path outPath) {
        outPath.reset();
        PointF initialPoint = shapeData.getInitialPoint();
        outPath.moveTo(initialPoint.x, initialPoint.y);
        PointF currentPoint = new PointF(initialPoint.x, initialPoint.y);
        for (int i = 0; i < shapeData.getCurves().size(); ++i) {
            CubicCurveData curveData = shapeData.getCurves().get(i);
            PointF cp1 = curveData.getControlPoint1();
            PointF cp2 = curveData.getControlPoint2();
            PointF vertex = curveData.getVertex();
            if (cp1.equals((Object)currentPoint) && cp2.equals((Object)vertex)) {
                outPath.lineTo(vertex.x, vertex.y);
            } else {
                outPath.cubicTo(cp1.x, cp1.y, cp2.x, cp2.y, vertex.x, vertex.y);
            }
            currentPoint.set(vertex.x, vertex.y);
        }
        if (shapeData.isClosed()) {
            outPath.close();
        }
    }

    public static float lerp(float a, float b, @FloatRange(from=0.0, to=1.0) float percentage) {
        return a + percentage * (b - a);
    }

    public static double lerp(double a, double b, @FloatRange(from=0.0, to=1.0) double percentage) {
        return a + percentage * (b - a);
    }

    public static int lerp(int a, int b, @FloatRange(from=0.0, to=1.0) float percentage) {
        return (int)((float)a + percentage * (float)(b - a));
    }

    public static int floorMod(float x, float y) {
        return MiscUtils.floorMod((int)x, (int)y);
    }

    public static int floorMod(int x, int y) {
        return x - MiscUtils.floorDiv(x, y) * y;
    }

    private static int floorDiv(int x, int y) {
        int r = x / y;
        if ((x ^ y) < 0 && r * y != x) {
            --r;
        }
        return r;
    }

    public static int clamp(int number, int min, int max) {
        return Math.max(min, Math.min(max, number));
    }

    public static float clamp(float number, float min, float max) {
        return Math.max(min, Math.min(max, number));
    }

    public static void resolveKeyPath(KeyPath keyPath, int depth, List<KeyPath> accumulator, KeyPath currentPartialKeyPath, KeyPathElementContent content) {
        if (keyPath.fullyResolvesTo(content.getName(), depth)) {
            currentPartialKeyPath = currentPartialKeyPath.addKey(content.getName());
            accumulator.add(currentPartialKeyPath.resolve(content));
        }
    }
}

