/*
 * Decompiled with CFR 0.152.
 */
package com.airbnb.lottie.model.animatable;

import android.support.annotation.Nullable;
import com.airbnb.lottie.LottieComposition;
import com.airbnb.lottie.animation.Keyframe;
import com.airbnb.lottie.model.animatable.AnimatableValue;
import java.util.Collections;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONObject;

class AnimatableValueParser<T> {
    private final JSONObject json;
    private final float scale;
    private final LottieComposition composition;
    private final AnimatableValue.Factory<T> valueFactory;

    private AnimatableValueParser(JSONObject json, float scale, LottieComposition composition, AnimatableValue.Factory<T> valueFactory) {
        this.json = json;
        this.scale = scale;
        this.composition = composition;
        this.valueFactory = valueFactory;
    }

    static <T> List<Keyframe<T>> newInstance(@Nullable JSONObject json, float scale, LottieComposition composition, AnimatableValue.Factory<T> valueFactory) {
        AnimatableValueParser<T> parser = new AnimatableValueParser<T>(json, scale, composition, valueFactory);
        return super.parseKeyframes();
    }

    private List<Keyframe<T>> parseKeyframes() {
        Object k = this.json.opt("k");
        if (AnimatableValueParser.hasKeyframes(k)) {
            return Keyframe.Factory.parseKeyframes((JSONArray)k, this.composition, this.scale, this.valueFactory);
        }
        return this.parseStaticValue();
    }

    private List<Keyframe<T>> parseStaticValue() {
        T initialValue = this.valueFactory.valueFromObject(this.json.opt("k"), this.scale);
        return Collections.singletonList(new Keyframe<T>(initialValue));
    }

    private static boolean hasKeyframes(Object json) {
        if (!(json instanceof JSONArray)) {
            return false;
        }
        Object firstObject = ((JSONArray)json).opt(0);
        return firstObject instanceof JSONObject && ((JSONObject)firstObject).has("t");
    }
}

