/*
 * Decompiled with CFR 0.152.
 */
package com.airbnb.lottie.model.animatable;

import android.graphics.PointF;
import com.airbnb.lottie.LottieComposition;
import com.airbnb.lottie.animation.Keyframe;
import com.airbnb.lottie.animation.keyframe.BaseKeyframeAnimation;
import com.airbnb.lottie.animation.keyframe.PathKeyframe;
import com.airbnb.lottie.animation.keyframe.PathKeyframeAnimation;
import com.airbnb.lottie.animation.keyframe.PointKeyframeAnimation;
import com.airbnb.lottie.model.animatable.AnimatableFloatValue;
import com.airbnb.lottie.model.animatable.AnimatableSplitDimensionPathValue;
import com.airbnb.lottie.model.animatable.AnimatableValue;
import com.airbnb.lottie.utils.JsonUtils;
import java.util.ArrayList;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONObject;

public class AnimatablePathValue
implements AnimatableValue<PointF, PointF> {
    private final List<Keyframe<PointF>> keyframes = new ArrayList<Keyframe<PointF>>();

    public static AnimatableValue<PointF, PointF> createAnimatablePathOrSplitDimensionPath(JSONObject json, LottieComposition composition) {
        if (json.has("k")) {
            return new AnimatablePathValue(json.opt("k"), composition);
        }
        return new AnimatableSplitDimensionPathValue(AnimatableFloatValue.Factory.newInstance(json.optJSONObject("x"), composition), AnimatableFloatValue.Factory.newInstance(json.optJSONObject("y"), composition));
    }

    AnimatablePathValue() {
        this.keyframes.add(new Keyframe<PointF>(new PointF(0.0f, 0.0f)));
    }

    AnimatablePathValue(Object json, LottieComposition composition) {
        if (this.hasKeyframes(json)) {
            JSONArray jsonArray = (JSONArray)json;
            int length = jsonArray.length();
            for (int i = 0; i < length; ++i) {
                JSONObject jsonKeyframe = jsonArray.optJSONObject(i);
                PathKeyframe keyframe = PathKeyframe.Factory.newInstance(jsonKeyframe, composition, ValueFactory.INSTANCE);
                this.keyframes.add(keyframe);
            }
            Keyframe.setEndFrames(this.keyframes);
        } else {
            this.keyframes.add(new Keyframe<PointF>(JsonUtils.pointFromJsonArray((JSONArray)json, composition.getDpScale())));
        }
    }

    private boolean hasKeyframes(Object json) {
        if (!(json instanceof JSONArray)) {
            return false;
        }
        Object firstObject = ((JSONArray)json).opt(0);
        return firstObject instanceof JSONObject && ((JSONObject)firstObject).has("t");
    }

    @Override
    public BaseKeyframeAnimation<PointF, PointF> createAnimation() {
        if (this.keyframes.get(0).isStatic()) {
            return new PointKeyframeAnimation(this.keyframes);
        }
        return new PathKeyframeAnimation((List<? extends Keyframe<PointF>>)this.keyframes);
    }

    private static class ValueFactory
    implements AnimatableValue.Factory<PointF> {
        private static final AnimatableValue.Factory<PointF> INSTANCE = new ValueFactory();

        private ValueFactory() {
        }

        @Override
        public PointF valueFromObject(Object object, float scale) {
            return JsonUtils.pointFromJsonArray((JSONArray)object, scale);
        }
    }
}

