/*
 * Decompiled with CFR 0.152.
 */
package com.airbnb.lottie.model.animatable;

import com.airbnb.lottie.LottieComposition;
import com.airbnb.lottie.animation.Keyframe;
import com.airbnb.lottie.animation.keyframe.BaseKeyframeAnimation;
import com.airbnb.lottie.animation.keyframe.IntegerKeyframeAnimation;
import com.airbnb.lottie.model.animatable.AnimatableValue;
import com.airbnb.lottie.model.animatable.AnimatableValueParser;
import com.airbnb.lottie.model.animatable.BaseAnimatableValue;
import com.airbnb.lottie.utils.JsonUtils;
import java.util.List;
import org.json.JSONObject;

public class AnimatableIntegerValue
extends BaseAnimatableValue<Integer, Integer> {
    private AnimatableIntegerValue() {
        this(100);
    }

    private AnimatableIntegerValue(Integer value) {
        super(value);
    }

    AnimatableIntegerValue(List<Keyframe<Integer>> keyframes) {
        super(keyframes);
    }

    @Override
    public BaseKeyframeAnimation<Integer, Integer> createAnimation() {
        return new IntegerKeyframeAnimation(this.keyframes);
    }

    private static class ValueFactory
    implements AnimatableValue.Factory<Integer> {
        private static final ValueFactory INSTANCE = new ValueFactory();

        private ValueFactory() {
        }

        @Override
        public Integer valueFromObject(Object object, float scale) {
            return Math.round(JsonUtils.valueFromObject(object) * scale);
        }
    }

    public static final class Factory {
        private Factory() {
        }

        static AnimatableIntegerValue newInstance() {
            return new AnimatableIntegerValue();
        }

        public static AnimatableIntegerValue newInstance(JSONObject json, LottieComposition composition) {
            if (json != null && json.has("x")) {
                composition.addWarning("Lottie doesn't support expressions.");
            }
            return new AnimatableIntegerValue(AnimatableValueParser.newInstance(json, 1.0f, composition, ValueFactory.INSTANCE));
        }
    }
}

