/*
 * Decompiled with CFR 0.152.
 */
package com.airbnb.lottie.animation.keyframe;

import android.support.annotation.FloatRange;
import android.support.annotation.Nullable;
import com.airbnb.lottie.animation.Keyframe;
import com.airbnb.lottie.value.LottieValueCallback;
import java.util.ArrayList;
import java.util.List;

public abstract class BaseKeyframeAnimation<K, A> {
    final List<AnimationListener> listeners = new ArrayList<AnimationListener>();
    private boolean isDiscrete = false;
    private final List<? extends Keyframe<K>> keyframes;
    private float progress = 0.0f;
    @Nullable
    protected LottieValueCallback<A> valueCallback;
    @Nullable
    private Keyframe<K> cachedKeyframe;

    BaseKeyframeAnimation(List<? extends Keyframe<K>> keyframes) {
        this.keyframes = keyframes;
    }

    public void setIsDiscrete() {
        this.isDiscrete = true;
    }

    public void addUpdateListener(AnimationListener listener) {
        this.listeners.add(listener);
    }

    public void setProgress(@FloatRange(from=0.0, to=1.0) float progress) {
        if (progress < this.getStartDelayProgress()) {
            progress = this.getStartDelayProgress();
        } else if (progress > this.getEndProgress()) {
            progress = this.getEndProgress();
        }
        if (progress == this.progress) {
            return;
        }
        this.progress = progress;
        this.notifyListeners();
    }

    void notifyListeners() {
        for (int i = 0; i < this.listeners.size(); ++i) {
            this.listeners.get(i).onValueChanged();
        }
    }

    private Keyframe<K> getCurrentKeyframe() {
        if (this.keyframes.isEmpty()) {
            throw new IllegalStateException("There are no keyframes");
        }
        if (this.cachedKeyframe != null && this.cachedKeyframe.containsProgress(this.progress)) {
            return this.cachedKeyframe;
        }
        Keyframe<K> keyframe = this.keyframes.get(this.keyframes.size() - 1);
        if (this.progress < keyframe.getStartProgress()) {
            for (int i = this.keyframes.size() - 1; i >= 0 && !(keyframe = this.keyframes.get(i)).containsProgress(this.progress); --i) {
            }
        }
        this.cachedKeyframe = keyframe;
        return keyframe;
    }

    float getLinearCurrentKeyframeProgress() {
        if (this.isDiscrete) {
            return 0.0f;
        }
        Keyframe<K> keyframe = this.getCurrentKeyframe();
        if (keyframe.isStatic()) {
            return 0.0f;
        }
        float progressIntoFrame = this.progress - keyframe.getStartProgress();
        float keyframeProgress = keyframe.getEndProgress() - keyframe.getStartProgress();
        return progressIntoFrame / keyframeProgress;
    }

    private float getInterpolatedCurrentKeyframeProgress() {
        Keyframe<K> keyframe = this.getCurrentKeyframe();
        if (keyframe.isStatic()) {
            return 0.0f;
        }
        return keyframe.interpolator.getInterpolation(this.getLinearCurrentKeyframeProgress());
    }

    @FloatRange(from=0.0, to=1.0)
    private float getStartDelayProgress() {
        return this.keyframes.isEmpty() ? 0.0f : this.keyframes.get(0).getStartProgress();
    }

    @FloatRange(from=0.0, to=1.0)
    float getEndProgress() {
        return this.keyframes.isEmpty() ? 1.0f : this.keyframes.get(this.keyframes.size() - 1).getEndProgress();
    }

    public A getValue() {
        return this.getValue(this.getCurrentKeyframe(), this.getInterpolatedCurrentKeyframeProgress());
    }

    public float getProgress() {
        return this.progress;
    }

    public void setValueCallback(@Nullable LottieValueCallback<A> valueCallback) {
        this.valueCallback = valueCallback;
    }

    abstract A getValue(Keyframe<K> var1, float var2);

    public static interface AnimationListener {
        public void onValueChanged();
    }
}

