/*
 * Decompiled with CFR 0.152.
 */
package com.airbnb.lottie.model.content;

import android.graphics.Path;
import android.support.annotation.Nullable;
import com.airbnb.lottie.LottieComposition;
import com.airbnb.lottie.LottieDrawable;
import com.airbnb.lottie.animation.content.Content;
import com.airbnb.lottie.animation.content.FillContent;
import com.airbnb.lottie.model.animatable.AnimatableColorValue;
import com.airbnb.lottie.model.animatable.AnimatableIntegerValue;
import com.airbnb.lottie.model.content.ContentModel;
import com.airbnb.lottie.model.layer.BaseLayer;
import org.json.JSONObject;

public class ShapeFill
implements ContentModel {
    private final boolean fillEnabled;
    private final Path.FillType fillType;
    private final String name;
    @Nullable
    private final AnimatableColorValue color;
    @Nullable
    private final AnimatableIntegerValue opacity;

    private ShapeFill(String name, boolean fillEnabled, Path.FillType fillType, @Nullable AnimatableColorValue color, @Nullable AnimatableIntegerValue opacity) {
        this.name = name;
        this.fillEnabled = fillEnabled;
        this.fillType = fillType;
        this.color = color;
        this.opacity = opacity;
    }

    public String getName() {
        return this.name;
    }

    @Nullable
    public AnimatableColorValue getColor() {
        return this.color;
    }

    @Nullable
    public AnimatableIntegerValue getOpacity() {
        return this.opacity;
    }

    public Path.FillType getFillType() {
        return this.fillType;
    }

    @Override
    public Content toContent(LottieDrawable drawable, BaseLayer layer) {
        return new FillContent(drawable, layer, this);
    }

    public String toString() {
        return "ShapeFill{color=" + (this.color == null ? "null" : Integer.toHexString((Integer)this.color.getInitialValue())) + ", fillEnabled=" + this.fillEnabled + ", opacity=" + (this.opacity == null ? "null" : this.opacity.getInitialValue()) + '}';
    }

    static class Factory {
        private Factory() {
        }

        static ShapeFill newInstance(JSONObject json, LottieComposition composition) {
            JSONObject jsonOpacity;
            AnimatableColorValue color = null;
            AnimatableIntegerValue opacity = null;
            String name = json.optString("nm");
            JSONObject jsonColor = json.optJSONObject("c");
            if (jsonColor != null) {
                color = AnimatableColorValue.Factory.newInstance(jsonColor, composition);
            }
            if ((jsonOpacity = json.optJSONObject("o")) != null) {
                opacity = AnimatableIntegerValue.Factory.newInstance(jsonOpacity, composition);
            }
            boolean fillEnabled = json.optBoolean("fillEnabled");
            int fillTypeInt = json.optInt("r", 1);
            Path.FillType fillType = fillTypeInt == 1 ? Path.FillType.WINDING : Path.FillType.EVEN_ODD;
            return new ShapeFill(name, fillEnabled, fillType, color, opacity);
        }
    }
}

