/*
 * Decompiled with CFR 0.152.
 */
package com.airbnb.lottie.model.content;

import android.support.annotation.Nullable;
import com.airbnb.lottie.LottieComposition;
import com.airbnb.lottie.LottieDrawable;
import com.airbnb.lottie.animation.content.Content;
import com.airbnb.lottie.animation.content.GradientStrokeContent;
import com.airbnb.lottie.model.animatable.AnimatableFloatValue;
import com.airbnb.lottie.model.animatable.AnimatableGradientColorValue;
import com.airbnb.lottie.model.animatable.AnimatableIntegerValue;
import com.airbnb.lottie.model.animatable.AnimatablePointValue;
import com.airbnb.lottie.model.content.ContentModel;
import com.airbnb.lottie.model.content.GradientType;
import com.airbnb.lottie.model.content.ShapeStroke;
import com.airbnb.lottie.model.layer.BaseLayer;
import java.util.ArrayList;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONObject;

public class GradientStroke
implements ContentModel {
    private final String name;
    private final GradientType gradientType;
    private final AnimatableGradientColorValue gradientColor;
    private final AnimatableIntegerValue opacity;
    private final AnimatablePointValue startPoint;
    private final AnimatablePointValue endPoint;
    private final AnimatableFloatValue width;
    private final ShapeStroke.LineCapType capType;
    private final ShapeStroke.LineJoinType joinType;
    private final List<AnimatableFloatValue> lineDashPattern;
    @Nullable
    private final AnimatableFloatValue dashOffset;

    private GradientStroke(String name, GradientType gradientType, AnimatableGradientColorValue gradientColor, AnimatableIntegerValue opacity, AnimatablePointValue startPoint, AnimatablePointValue endPoint, AnimatableFloatValue width, ShapeStroke.LineCapType capType, ShapeStroke.LineJoinType joinType, List<AnimatableFloatValue> lineDashPattern, @Nullable AnimatableFloatValue dashOffset) {
        this.name = name;
        this.gradientType = gradientType;
        this.gradientColor = gradientColor;
        this.opacity = opacity;
        this.startPoint = startPoint;
        this.endPoint = endPoint;
        this.width = width;
        this.capType = capType;
        this.joinType = joinType;
        this.lineDashPattern = lineDashPattern;
        this.dashOffset = dashOffset;
    }

    public String getName() {
        return this.name;
    }

    public GradientType getGradientType() {
        return this.gradientType;
    }

    public AnimatableGradientColorValue getGradientColor() {
        return this.gradientColor;
    }

    public AnimatableIntegerValue getOpacity() {
        return this.opacity;
    }

    public AnimatablePointValue getStartPoint() {
        return this.startPoint;
    }

    public AnimatablePointValue getEndPoint() {
        return this.endPoint;
    }

    public AnimatableFloatValue getWidth() {
        return this.width;
    }

    public ShapeStroke.LineCapType getCapType() {
        return this.capType;
    }

    public ShapeStroke.LineJoinType getJoinType() {
        return this.joinType;
    }

    public List<AnimatableFloatValue> getLineDashPattern() {
        return this.lineDashPattern;
    }

    @Nullable
    public AnimatableFloatValue getDashOffset() {
        return this.dashOffset;
    }

    @Override
    public Content toContent(LottieDrawable drawable, BaseLayer layer) {
        return new GradientStrokeContent(drawable, layer, this);
    }

    static class Factory {
        private Factory() {
        }

        static GradientStroke newInstance(JSONObject json, LottieComposition composition) {
            int gradientTypeInt;
            String name = json.optString("nm");
            JSONObject jsonColor = json.optJSONObject("g");
            if (jsonColor != null && jsonColor.has("k")) {
                jsonColor = jsonColor.optJSONObject("k");
            }
            AnimatableGradientColorValue color = null;
            if (jsonColor != null) {
                color = AnimatableGradientColorValue.Factory.newInstance(jsonColor, composition);
            }
            JSONObject jsonOpacity = json.optJSONObject("o");
            AnimatableIntegerValue opacity = null;
            if (jsonOpacity != null) {
                opacity = AnimatableIntegerValue.Factory.newInstance(jsonOpacity, composition);
            }
            GradientType gradientType = (gradientTypeInt = json.optInt("t", 1)) == 1 ? GradientType.Linear : GradientType.Radial;
            JSONObject jsonStartPoint = json.optJSONObject("s");
            AnimatablePointValue startPoint = null;
            if (jsonStartPoint != null) {
                startPoint = AnimatablePointValue.Factory.newInstance(jsonStartPoint, composition);
            }
            JSONObject jsonEndPoint = json.optJSONObject("e");
            AnimatablePointValue endPoint = null;
            if (jsonEndPoint != null) {
                endPoint = AnimatablePointValue.Factory.newInstance(jsonEndPoint, composition);
            }
            AnimatableFloatValue width = AnimatableFloatValue.Factory.newInstance(json.optJSONObject("w"), composition);
            ShapeStroke.LineCapType capType = ShapeStroke.LineCapType.values()[json.optInt("lc") - 1];
            ShapeStroke.LineJoinType joinType = ShapeStroke.LineJoinType.values()[json.optInt("lj") - 1];
            AnimatableFloatValue offset = null;
            ArrayList<AnimatableFloatValue> lineDashPattern = new ArrayList<AnimatableFloatValue>();
            if (json.has("d")) {
                JSONArray dashesJson = json.optJSONArray("d");
                for (int i = 0; i < dashesJson.length(); ++i) {
                    JSONObject value;
                    JSONObject dashJson = dashesJson.optJSONObject(i);
                    String n = dashJson.optString("n");
                    if (n.equals("o")) {
                        value = dashJson.optJSONObject("v");
                        offset = AnimatableFloatValue.Factory.newInstance(value, composition);
                        continue;
                    }
                    if (!n.equals("d") && !n.equals("g")) continue;
                    value = dashJson.optJSONObject("v");
                    lineDashPattern.add(AnimatableFloatValue.Factory.newInstance(value, composition));
                }
                if (lineDashPattern.size() == 1) {
                    lineDashPattern.add((AnimatableFloatValue)lineDashPattern.get(0));
                }
            }
            return new GradientStroke(name, gradientType, color, opacity, startPoint, endPoint, width, capType, joinType, lineDashPattern, offset);
        }
    }
}

