/*
 * Decompiled with CFR 0.152.
 */
package com.airbnb.lottie.model.animatable;

import android.graphics.Path;
import com.airbnb.lottie.LottieComposition;
import com.airbnb.lottie.animation.Keyframe;
import com.airbnb.lottie.animation.keyframe.BaseKeyframeAnimation;
import com.airbnb.lottie.animation.keyframe.ShapeKeyframeAnimation;
import com.airbnb.lottie.animation.keyframe.StaticKeyframeAnimation;
import com.airbnb.lottie.model.animatable.AnimatableValueParser;
import com.airbnb.lottie.model.animatable.BaseAnimatableValue;
import com.airbnb.lottie.model.content.ShapeData;
import com.airbnb.lottie.utils.MiscUtils;
import java.util.List;
import org.json.JSONObject;

public class AnimatableShapeValue
extends BaseAnimatableValue<ShapeData, Path> {
    private final Path convertTypePath = new Path();

    private AnimatableShapeValue(List<Keyframe<ShapeData>> keyframes, ShapeData initialValue) {
        super(keyframes, initialValue);
    }

    @Override
    public BaseKeyframeAnimation<ShapeData, Path> createAnimation() {
        if (!this.hasAnimation()) {
            return new StaticKeyframeAnimation<ShapeData, Path>(this.convertType((ShapeData)this.initialValue));
        }
        return new ShapeKeyframeAnimation(this.keyframes);
    }

    @Override
    Path convertType(ShapeData shapeData) {
        this.convertTypePath.reset();
        MiscUtils.getPathFromData(shapeData, this.convertTypePath);
        return this.convertTypePath;
    }

    public static final class Factory {
        private Factory() {
        }

        public static AnimatableShapeValue newInstance(JSONObject json, LottieComposition composition) {
            AnimatableValueParser.Result<ShapeData> result = AnimatableValueParser.newInstance(json, composition.getDpScale(), composition, ShapeData.Factory.INSTANCE).parseJson();
            return new AnimatableShapeValue(result.keyframes, (ShapeData)result.initialValue);
        }
    }
}

