/*
 * Decompiled with CFR 0.152.
 */
package com.airbnb.lottie.animation.content;

import android.graphics.Canvas;
import android.graphics.ColorFilter;
import android.graphics.Matrix;
import android.graphics.Path;
import android.graphics.RectF;
import android.support.annotation.Nullable;
import com.airbnb.lottie.LottieDrawable;
import com.airbnb.lottie.animation.content.Content;
import com.airbnb.lottie.animation.content.DrawingContent;
import com.airbnb.lottie.animation.content.GreedyContent;
import com.airbnb.lottie.animation.content.PathContent;
import com.airbnb.lottie.animation.keyframe.BaseKeyframeAnimation;
import com.airbnb.lottie.animation.keyframe.TransformKeyframeAnimation;
import com.airbnb.lottie.model.animatable.AnimatableTransform;
import com.airbnb.lottie.model.content.ContentModel;
import com.airbnb.lottie.model.content.ShapeGroup;
import com.airbnb.lottie.model.layer.BaseLayer;
import java.util.ArrayList;
import java.util.List;

public class ContentGroup
implements DrawingContent,
PathContent,
BaseKeyframeAnimation.AnimationListener {
    private final Matrix matrix = new Matrix();
    private final Path path = new Path();
    private final RectF rect = new RectF();
    private final String name;
    private final List<Content> contents;
    private final LottieDrawable lottieDrawable;
    @Nullable
    private List<PathContent> pathContents;
    @Nullable
    private TransformKeyframeAnimation transformAnimation;

    private static List<Content> contentsFromModels(LottieDrawable drawable, BaseLayer layer, List<ContentModel> contentModels) {
        ArrayList<Content> contents = new ArrayList<Content>(contentModels.size());
        for (int i = 0; i < contentModels.size(); ++i) {
            Content content = contentModels.get(i).toContent(drawable, layer);
            if (content == null) continue;
            contents.add(content);
        }
        return contents;
    }

    @Nullable
    static AnimatableTransform findTransform(List<ContentModel> contentModels) {
        for (int i = 0; i < contentModels.size(); ++i) {
            ContentModel contentModel = contentModels.get(i);
            if (!(contentModel instanceof AnimatableTransform)) continue;
            return (AnimatableTransform)contentModel;
        }
        return null;
    }

    public ContentGroup(LottieDrawable lottieDrawable, BaseLayer layer, ShapeGroup shapeGroup) {
        this(lottieDrawable, layer, shapeGroup.getName(), ContentGroup.contentsFromModels(lottieDrawable, layer, shapeGroup.getItems()), ContentGroup.findTransform(shapeGroup.getItems()));
    }

    ContentGroup(LottieDrawable lottieDrawable, BaseLayer layer, String name, List<Content> contents, @Nullable AnimatableTransform transform) {
        int i;
        this.name = name;
        this.lottieDrawable = lottieDrawable;
        this.contents = contents;
        if (transform != null) {
            this.transformAnimation = transform.createAnimation();
            this.transformAnimation.addAnimationsToLayer(layer);
            this.transformAnimation.addListener(this);
        }
        ArrayList<GreedyContent> greedyContents = new ArrayList<GreedyContent>();
        for (i = contents.size() - 1; i >= 0; --i) {
            Content content = contents.get(i);
            if (!(content instanceof GreedyContent)) continue;
            greedyContents.add((GreedyContent)((Object)content));
        }
        for (i = greedyContents.size() - 1; i >= 0; --i) {
            ((GreedyContent)greedyContents.get(i)).absorbContent(contents.listIterator(contents.size()));
        }
    }

    @Override
    public void onValueChanged() {
        this.lottieDrawable.invalidateSelf();
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void addColorFilter(@Nullable String layerName, @Nullable String contentName, @Nullable ColorFilter colorFilter) {
        for (int i = 0; i < this.contents.size(); ++i) {
            Content content = this.contents.get(i);
            if (!(content instanceof DrawingContent)) continue;
            DrawingContent drawingContent = (DrawingContent)content;
            if (contentName == null || contentName.equals(content.getName())) {
                drawingContent.addColorFilter(layerName, null, colorFilter);
                continue;
            }
            drawingContent.addColorFilter(layerName, contentName, colorFilter);
        }
    }

    @Override
    public void setContents(List<Content> contentsBefore, List<Content> contentsAfter) {
        ArrayList<Content> myContentsBefore = new ArrayList<Content>(contentsBefore.size() + this.contents.size());
        myContentsBefore.addAll(contentsBefore);
        for (int i = this.contents.size() - 1; i >= 0; --i) {
            Content content = this.contents.get(i);
            content.setContents(myContentsBefore, this.contents.subList(0, i));
            myContentsBefore.add(content);
        }
    }

    List<PathContent> getPathList() {
        if (this.pathContents == null) {
            this.pathContents = new ArrayList<PathContent>();
            for (int i = 0; i < this.contents.size(); ++i) {
                Content content = this.contents.get(i);
                if (!(content instanceof PathContent)) continue;
                this.pathContents.add((PathContent)content);
            }
        }
        return this.pathContents;
    }

    Matrix getTransformationMatrix() {
        if (this.transformAnimation != null) {
            return this.transformAnimation.getMatrix();
        }
        this.matrix.reset();
        return this.matrix;
    }

    @Override
    public Path getPath() {
        this.matrix.reset();
        if (this.transformAnimation != null) {
            this.matrix.set(this.transformAnimation.getMatrix());
        }
        this.path.reset();
        for (int i = this.contents.size() - 1; i >= 0; --i) {
            Content content = this.contents.get(i);
            if (!(content instanceof PathContent)) continue;
            this.path.addPath(((PathContent)content).getPath(), this.matrix);
        }
        return this.path;
    }

    @Override
    public void draw(Canvas canvas, Matrix parentMatrix, int parentAlpha) {
        int alpha;
        this.matrix.set(parentMatrix);
        if (this.transformAnimation != null) {
            this.matrix.preConcat(this.transformAnimation.getMatrix());
            alpha = (int)((float)this.transformAnimation.getOpacity().getValue().intValue() / 100.0f * (float)parentAlpha / 255.0f * 255.0f);
        } else {
            alpha = parentAlpha;
        }
        for (int i = this.contents.size() - 1; i >= 0; --i) {
            Content content = this.contents.get(i);
            if (!(content instanceof DrawingContent)) continue;
            ((DrawingContent)content).draw(canvas, this.matrix, alpha);
        }
    }

    @Override
    public void getBounds(RectF outBounds, Matrix parentMatrix) {
        this.matrix.set(parentMatrix);
        if (this.transformAnimation != null) {
            this.matrix.preConcat(this.transformAnimation.getMatrix());
        }
        this.rect.set(0.0f, 0.0f, 0.0f, 0.0f);
        for (int i = this.contents.size() - 1; i >= 0; --i) {
            Content content = this.contents.get(i);
            if (!(content instanceof DrawingContent)) continue;
            ((DrawingContent)content).getBounds(this.rect, this.matrix);
            if (outBounds.isEmpty()) {
                outBounds.set(this.rect);
                continue;
            }
            outBounds.set(Math.min(outBounds.left, this.rect.left), Math.min(outBounds.top, this.rect.top), Math.max(outBounds.right, this.rect.right), Math.max(outBounds.bottom, this.rect.bottom));
        }
    }
}

