/*
 * Decompiled with CFR 0.152.
 */
package com.airbnb.lottie;

import android.animation.Animator;
import android.animation.AnimatorListenerAdapter;
import android.animation.ValueAnimator;

class LottieValueAnimator
extends ValueAnimator {
    private boolean isReversed = false;
    private float startProgress = 0.0f;
    private float endProgress = 1.0f;
    private long duration;

    LottieValueAnimator() {
        this.setFloatValues(new float[]{0.0f, 1.0f});
        this.addListener((Animator.AnimatorListener)new AnimatorListenerAdapter(){

            public void onAnimationEnd(Animator animation) {
                LottieValueAnimator.this.updateValues();
            }

            public void onAnimationCancel(Animator animation) {
                LottieValueAnimator.this.updateValues();
            }
        });
    }

    public ValueAnimator setDuration(long duration) {
        this.duration = duration;
        this.updateValues();
        return this;
    }

    public long getDuration() {
        return this.duration;
    }

    void setIsReversed(boolean isReversed) {
        this.isReversed = isReversed;
        this.updateValues();
    }

    void setStartProgress(float startProgress) {
        this.startProgress = startProgress;
        this.updateValues();
    }

    void setEndProgress(float endProgress) {
        this.endProgress = endProgress;
        this.updateValues();
    }

    void updateValues(float startProgress, float endProgress) {
        float minValue = Math.min(startProgress, endProgress);
        float maxValue = Math.max(startProgress, endProgress);
        this.setFloatValues(new float[]{this.isReversed ? maxValue : minValue, this.isReversed ? minValue : maxValue});
        super.setDuration((long)((float)this.duration * (maxValue - minValue)));
    }

    private void updateValues() {
        this.updateValues(this.startProgress, this.endProgress);
    }
}

