/*
 * Decompiled with CFR 0.152.
 */
package com.airbnb.lottie;

import android.animation.Animator;
import android.animation.TimeInterpolator;
import android.animation.ValueAnimator;
import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.ColorFilter;
import android.graphics.Matrix;
import android.graphics.Typeface;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.support.annotation.FloatRange;
import android.support.annotation.IntRange;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.util.Log;
import android.view.View;
import android.view.animation.LinearInterpolator;
import com.airbnb.lottie.CompositionLayer;
import com.airbnb.lottie.FontAssetDelegate;
import com.airbnb.lottie.FontAssetManager;
import com.airbnb.lottie.ImageAssetDelegate;
import com.airbnb.lottie.ImageAssetManager;
import com.airbnb.lottie.L;
import com.airbnb.lottie.Layer;
import com.airbnb.lottie.LottieComposition;
import com.airbnb.lottie.LottieValueAnimator;
import com.airbnb.lottie.PerformanceTracker;
import com.airbnb.lottie.TextDelegate;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

public class LottieDrawable
extends Drawable
implements Drawable.Callback {
    private static final String TAG = LottieDrawable.class.getSimpleName();
    private final Matrix matrix = new Matrix();
    private LottieComposition composition;
    private final LottieValueAnimator animator = new LottieValueAnimator();
    private float speed = 1.0f;
    private float progress = 0.0f;
    private float scale = 1.0f;
    private final Set<ColorFilterData> colorFilterData = new HashSet<ColorFilterData>();
    private final ArrayList<LazyCompositionTask> lazyCompositionTasks = new ArrayList();
    @Nullable
    private ImageAssetManager imageAssetManager;
    @Nullable
    private String imageAssetsFolder;
    @Nullable
    private ImageAssetDelegate imageAssetDelegate;
    @Nullable
    private FontAssetManager fontAssetManager;
    @Nullable
    FontAssetDelegate fontAssetDelegate;
    @Nullable
    TextDelegate textDelegate;
    private boolean systemAnimationsAreDisabled;
    private boolean enableMergePaths;
    @Nullable
    private CompositionLayer compositionLayer;
    private int alpha = 255;
    private boolean performanceTrackingEnabled;

    public LottieDrawable() {
        this.animator.setRepeatCount(0);
        this.animator.setInterpolator((TimeInterpolator)new LinearInterpolator());
        this.animator.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

            public void onAnimationUpdate(ValueAnimator animation) {
                if (LottieDrawable.this.systemAnimationsAreDisabled) {
                    LottieDrawable.this.animator.cancel();
                    LottieDrawable.this.setProgress(1.0f);
                } else {
                    LottieDrawable.this.setProgress(((Float)animation.getAnimatedValue()).floatValue());
                }
            }
        });
    }

    public boolean hasMasks() {
        return this.compositionLayer != null && this.compositionLayer.hasMasks();
    }

    public boolean hasMatte() {
        return this.compositionLayer != null && this.compositionLayer.hasMatte();
    }

    boolean enableMergePathsForKitKatAndAbove() {
        return this.enableMergePaths;
    }

    public void enableMergePathsForKitKatAndAbove(boolean enable) {
        if (Build.VERSION.SDK_INT < 19) {
            Log.w((String)TAG, (String)"Merge paths are not supported pre-Kit Kat.");
            return;
        }
        this.enableMergePaths = enable;
        if (this.composition != null) {
            this.buildCompositionLayer();
        }
    }

    public void setImagesAssetsFolder(@Nullable String imageAssetsFolder) {
        this.imageAssetsFolder = imageAssetsFolder;
    }

    @Nullable
    public String getImageAssetsFolder() {
        return this.imageAssetsFolder;
    }

    public void recycleBitmaps() {
        if (this.imageAssetManager != null) {
            this.imageAssetManager.recycleBitmaps();
        }
    }

    public boolean setComposition(LottieComposition composition) {
        if (this.composition == composition) {
            return false;
        }
        this.clearComposition();
        this.composition = composition;
        this.setSpeed(this.speed);
        this.updateBounds();
        this.buildCompositionLayer();
        this.applyColorFilters();
        this.setProgress(this.progress);
        Iterator<LazyCompositionTask> it = this.lazyCompositionTasks.iterator();
        while (it.hasNext()) {
            LazyCompositionTask t = it.next();
            t.run(composition);
            it.remove();
        }
        composition.setPerformanceTrackingEnabled(this.performanceTrackingEnabled);
        return true;
    }

    public void setPerformanceTrackingEnabled(boolean enabled) {
        this.performanceTrackingEnabled = enabled;
        if (this.composition != null) {
            this.composition.setPerformanceTrackingEnabled(enabled);
        }
    }

    @Nullable
    public PerformanceTracker getPerformanceTracker() {
        if (this.composition != null) {
            return this.composition.getPerformanceTracker();
        }
        return null;
    }

    private void buildCompositionLayer() {
        this.compositionLayer = new CompositionLayer(this, Layer.Factory.newInstance(this.composition), this.composition.getLayers(), this.composition);
    }

    private void applyColorFilters() {
        if (this.compositionLayer == null) {
            return;
        }
        for (ColorFilterData data : this.colorFilterData) {
            this.compositionLayer.addColorFilter(data.layerName, data.contentName, data.colorFilter);
        }
    }

    private void clearComposition() {
        this.recycleBitmaps();
        this.compositionLayer = null;
        this.imageAssetManager = null;
        this.invalidateSelf();
    }

    public void invalidateSelf() {
        Drawable.Callback callback = this.getCallback();
        if (callback != null) {
            callback.invalidateDrawable((Drawable)this);
        }
    }

    public void setAlpha(@IntRange(from=0L, to=255L) int alpha) {
        this.alpha = alpha;
    }

    public int getAlpha() {
        return this.alpha;
    }

    public void setColorFilter(@Nullable ColorFilter colorFilter) {
    }

    public void addColorFilterToContent(String layerName, String contentName, @Nullable ColorFilter colorFilter) {
        this.addColorFilterInternal(layerName, contentName, colorFilter);
    }

    public void addColorFilterToLayer(String layerName, @Nullable ColorFilter colorFilter) {
        this.addColorFilterInternal(layerName, null, colorFilter);
    }

    public void addColorFilter(ColorFilter colorFilter) {
        this.addColorFilterInternal(null, null, colorFilter);
    }

    public void clearColorFilters() {
        this.colorFilterData.clear();
        this.addColorFilterInternal(null, null, null);
    }

    private void addColorFilterInternal(@Nullable String layerName, @Nullable String contentName, @Nullable ColorFilter colorFilter) {
        ColorFilterData data = new ColorFilterData(layerName, contentName, colorFilter);
        if (colorFilter == null && this.colorFilterData.contains(data)) {
            this.colorFilterData.remove(data);
        } else {
            this.colorFilterData.add(new ColorFilterData(layerName, contentName, colorFilter));
        }
        if (this.compositionLayer == null) {
            return;
        }
        this.compositionLayer.addColorFilter(layerName, contentName, colorFilter);
    }

    public int getOpacity() {
        return -3;
    }

    public void draw(@NonNull Canvas canvas) {
        L.beginSection("Drawable#draw");
        if (this.compositionLayer == null) {
            return;
        }
        float scale = this.scale;
        float extraScale = 1.0f;
        boolean hasExtraScale = false;
        float maxScale = this.getMaxScale(canvas);
        if (this.compositionLayer.hasMatte() || this.compositionLayer.hasMasks()) {
            extraScale = scale / maxScale;
            scale = Math.min(scale, maxScale);
            boolean bl = hasExtraScale = extraScale > 1.001f;
        }
        if (hasExtraScale) {
            canvas.save();
            float extraScaleSquared = extraScale * extraScale;
            int px = (int)((float)this.composition.getBounds().width() * scale / 2.0f);
            int py = (int)((float)this.composition.getBounds().height() * scale / 2.0f);
            canvas.scale(extraScaleSquared, extraScaleSquared, (float)px, (float)py);
        }
        this.matrix.reset();
        this.matrix.preScale(scale, scale);
        this.compositionLayer.draw(canvas, this.matrix, this.alpha);
        if (hasExtraScale) {
            canvas.restore();
        }
        L.endSection("Drawable#draw");
    }

    void systemAnimationsAreDisabled() {
        this.systemAnimationsAreDisabled = true;
    }

    public void loop(boolean loop) {
        this.animator.setRepeatCount(loop ? -1 : 0);
    }

    public boolean isLooping() {
        return this.animator.getRepeatCount() == -1;
    }

    public boolean isAnimating() {
        return this.animator.isRunning();
    }

    public void playAnimation() {
        this.playAnimation((double)this.progress > 0.0 && (double)this.progress < 1.0);
    }

    public void resumeAnimation() {
        this.playAnimation(true);
    }

    private void playAnimation(boolean setStartTime) {
        if (this.compositionLayer == null) {
            this.lazyCompositionTasks.add(new LazyCompositionTask(){

                @Override
                public void run(LottieComposition composition) {
                    LottieDrawable.this.playAnimation();
                }
            });
            return;
        }
        long playTime = setStartTime ? (long)(this.progress * (float)this.animator.getDuration()) : 0L;
        this.animator.start();
        if (setStartTime) {
            this.animator.setCurrentPlayTime(playTime);
        }
    }

    public void playAnimation(final int startFrame, final int endFrame) {
        if (this.composition == null) {
            this.lazyCompositionTasks.add(new LazyCompositionTask(){

                @Override
                public void run(LottieComposition composition) {
                    LottieDrawable.this.playAnimation((float)startFrame / composition.getDurationFrames(), (float)endFrame / composition.getDurationFrames());
                }
            });
            return;
        }
        this.playAnimation((float)startFrame / this.composition.getDurationFrames(), (float)endFrame / this.composition.getDurationFrames());
    }

    public void playAnimation(@FloatRange(from=0.0, to=1.0) float startProgress, @FloatRange(from=0.0, to=1.0) float endProgress) {
        this.animator.updateValues(startProgress, endProgress);
        this.animator.setCurrentPlayTime(0L);
        this.setProgress(startProgress);
        this.playAnimation(false);
    }

    public void resumeReverseAnimation() {
        this.reverseAnimation(true);
    }

    public void reverseAnimation() {
        this.reverseAnimation((double)this.progress > 0.0 && (double)this.progress < 1.0);
    }

    private void reverseAnimation(boolean setStartTime) {
        if (this.compositionLayer == null) {
            this.lazyCompositionTasks.add(new LazyCompositionTask(){

                @Override
                public void run(LottieComposition composition) {
                    LottieDrawable.this.reverseAnimation();
                }
            });
            return;
        }
        if (setStartTime) {
            this.animator.setCurrentPlayTime((long)(this.progress * (float)this.animator.getDuration()));
        }
        this.animator.reverse();
    }

    public void setMinFrame(final int startFrame) {
        if (this.composition == null) {
            this.lazyCompositionTasks.add(new LazyCompositionTask(){

                @Override
                public void run(LottieComposition composition) {
                    LottieDrawable.this.setMinProgress((float)startFrame / composition.getDurationFrames());
                }
            });
            return;
        }
        this.setMinProgress((float)startFrame / this.composition.getDurationFrames());
    }

    public void setMinProgress(float startProgress) {
        this.animator.setStartProgress(startProgress);
    }

    public void setMaxFrame(final int endFrame) {
        if (this.composition == null) {
            this.lazyCompositionTasks.add(new LazyCompositionTask(){

                @Override
                public void run(LottieComposition composition) {
                    LottieDrawable.this.setMaxProgress((float)endFrame / composition.getDurationFrames());
                }
            });
            return;
        }
        this.setMaxProgress((float)endFrame / this.composition.getDurationFrames());
    }

    public void setMaxProgress(float endProgress) {
        this.animator.setEndProgress(endProgress);
    }

    public void setMinAndMaxFrame(int minFrame, int maxFrame) {
        this.setMinFrame(minFrame);
        this.setMaxFrame(maxFrame);
    }

    public void setMinAndMaxProgress(float minProgress, float maxProgress) {
        this.setMinProgress(minProgress);
        this.setMaxProgress(maxProgress);
    }

    public void setSpeed(float speed) {
        this.speed = speed;
        this.animator.setIsReversed(speed < 0.0f);
        if (this.composition != null) {
            this.animator.setDuration((long)((float)this.composition.getDuration() / Math.abs(speed)));
        }
    }

    public void setProgress(@FloatRange(from=0.0, to=1.0) float progress) {
        this.progress = progress;
        if (this.compositionLayer != null) {
            this.compositionLayer.setProgress(progress);
        }
    }

    public float getProgress() {
        return this.progress;
    }

    public void setScale(float scale) {
        this.scale = scale;
        this.updateBounds();
    }

    public void setImageAssetDelegate(ImageAssetDelegate assetDelegate) {
        this.imageAssetDelegate = assetDelegate;
        if (this.imageAssetManager != null) {
            this.imageAssetManager.setDelegate(assetDelegate);
        }
    }

    public void setFontAssetDelegate(FontAssetDelegate assetDelegate) {
        this.fontAssetDelegate = assetDelegate;
        if (this.fontAssetManager != null) {
            this.fontAssetManager.setDelegate(assetDelegate);
        }
    }

    public void setTextDelegate(TextDelegate textDelegate) {
        this.textDelegate = textDelegate;
    }

    @Nullable
    TextDelegate getTextDelegate() {
        return this.textDelegate;
    }

    boolean useTextGlyphs() {
        return this.textDelegate == null && this.composition.getCharacters().size() > 0;
    }

    public float getScale() {
        return this.scale;
    }

    public LottieComposition getComposition() {
        return this.composition;
    }

    private void updateBounds() {
        if (this.composition == null) {
            return;
        }
        float scale = this.getScale();
        this.setBounds(0, 0, (int)((float)this.composition.getBounds().width() * scale), (int)((float)this.composition.getBounds().height() * scale));
    }

    public void cancelAnimation() {
        this.lazyCompositionTasks.clear();
        this.animator.cancel();
    }

    public void addAnimatorUpdateListener(ValueAnimator.AnimatorUpdateListener updateListener) {
        this.animator.addUpdateListener(updateListener);
    }

    public void removeAnimatorUpdateListener(ValueAnimator.AnimatorUpdateListener updateListener) {
        this.animator.removeUpdateListener(updateListener);
    }

    public void addAnimatorListener(Animator.AnimatorListener listener) {
        this.animator.addListener(listener);
    }

    public void removeAnimatorListener(Animator.AnimatorListener listener) {
        this.animator.removeListener(listener);
    }

    public int getIntrinsicWidth() {
        return this.composition == null ? -1 : (int)((float)this.composition.getBounds().width() * this.scale);
    }

    public int getIntrinsicHeight() {
        return this.composition == null ? -1 : (int)((float)this.composition.getBounds().height() * this.scale);
    }

    @Nullable
    public Bitmap updateBitmap(String id, @Nullable Bitmap bitmap) {
        ImageAssetManager bm = this.getImageAssetManager();
        if (bm == null) {
            Log.w((String)"LOTTIE", (String)"Cannot update bitmap. Most likely the drawable is not added to a View which prevents Lottie from getting a Context.");
            return null;
        }
        Bitmap ret = bm.updateBitmap(id, bitmap);
        this.invalidateSelf();
        return ret;
    }

    @Nullable
    Bitmap getImageAsset(String id) {
        ImageAssetManager bm = this.getImageAssetManager();
        if (bm != null) {
            return bm.bitmapForId(id);
        }
        return null;
    }

    private ImageAssetManager getImageAssetManager() {
        if (this.getCallback() == null) {
            return null;
        }
        if (this.imageAssetManager != null && !this.imageAssetManager.hasSameContext(this.getContext())) {
            this.imageAssetManager.recycleBitmaps();
            this.imageAssetManager = null;
        }
        if (this.imageAssetManager == null) {
            this.imageAssetManager = new ImageAssetManager(this.getCallback(), this.imageAssetsFolder, this.imageAssetDelegate, this.composition.getImages());
        }
        return this.imageAssetManager;
    }

    @Nullable
    Typeface getTypeface(String fontFamily, String style) {
        FontAssetManager assetManager = this.getFontAssetManager();
        if (assetManager != null) {
            return assetManager.getTypeface(fontFamily, style);
        }
        return null;
    }

    private FontAssetManager getFontAssetManager() {
        if (this.getCallback() == null) {
            return null;
        }
        if (this.fontAssetManager == null) {
            this.fontAssetManager = new FontAssetManager(this.getCallback(), this.fontAssetDelegate);
        }
        return this.fontAssetManager;
    }

    @Nullable
    private Context getContext() {
        Drawable.Callback callback = this.getCallback();
        if (callback == null) {
            return null;
        }
        if (callback instanceof View) {
            return ((View)callback).getContext();
        }
        return null;
    }

    private float getMaxScale(@NonNull Canvas canvas) {
        float maxScaleX = (float)canvas.getWidth() / (float)this.composition.getBounds().width();
        float maxScaleY = (float)canvas.getHeight() / (float)this.composition.getBounds().height();
        return Math.min(maxScaleX, maxScaleY);
    }

    public void invalidateDrawable(@NonNull Drawable who) {
        Drawable.Callback callback = this.getCallback();
        if (callback == null) {
            return;
        }
        callback.invalidateDrawable((Drawable)this);
    }

    public void scheduleDrawable(@NonNull Drawable who, @NonNull Runnable what, long when) {
        Drawable.Callback callback = this.getCallback();
        if (callback == null) {
            return;
        }
        callback.scheduleDrawable((Drawable)this, what, when);
    }

    public void unscheduleDrawable(@NonNull Drawable who, @NonNull Runnable what) {
        Drawable.Callback callback = this.getCallback();
        if (callback == null) {
            return;
        }
        callback.unscheduleDrawable((Drawable)this, what);
    }

    private static class ColorFilterData {
        final String layerName;
        @Nullable
        final String contentName;
        @Nullable
        final ColorFilter colorFilter;

        ColorFilterData(@Nullable String layerName, @Nullable String contentName, @Nullable ColorFilter colorFilter) {
            this.layerName = layerName;
            this.contentName = contentName;
            this.colorFilter = colorFilter;
        }

        public int hashCode() {
            int hashCode = 17;
            if (this.layerName != null) {
                hashCode = hashCode * 31 * this.layerName.hashCode();
            }
            if (this.contentName != null) {
                hashCode = hashCode * 31 * this.contentName.hashCode();
            }
            return hashCode;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof ColorFilterData)) {
                return false;
            }
            ColorFilterData other = (ColorFilterData)obj;
            return this.hashCode() == other.hashCode() && this.colorFilter == other.colorFilter;
        }
    }

    private static interface LazyCompositionTask {
        public void run(LottieComposition var1);
    }
}

