/*
 * Decompiled with CFR 0.152.
 */
package com.airbnb.lottie;

import android.graphics.Canvas;
import android.graphics.ColorFilter;
import android.graphics.Matrix;
import android.graphics.Rect;
import android.graphics.RectF;
import android.graphics.Region;
import android.support.annotation.FloatRange;
import android.support.annotation.Nullable;
import android.support.v4.util.LongSparseArray;
import com.airbnb.lottie.AnimatableFloatValue;
import com.airbnb.lottie.BaseLayer;
import com.airbnb.lottie.KeyframeAnimation;
import com.airbnb.lottie.L;
import com.airbnb.lottie.Layer;
import com.airbnb.lottie.LottieComposition;
import com.airbnb.lottie.LottieDrawable;
import com.airbnb.lottie.ShapeLayer;
import java.util.ArrayList;
import java.util.List;

class CompositionLayer
extends BaseLayer {
    @Nullable
    private final KeyframeAnimation<Float> timeRemapping;
    private final List<BaseLayer> layers = new ArrayList<BaseLayer>();
    private final RectF rect = new RectF();
    private final Rect originalClipRect = new Rect();
    private final RectF newClipRect = new RectF();
    @Nullable
    private Boolean hasMatte;
    @Nullable
    private Boolean hasMasks;

    CompositionLayer(LottieDrawable lottieDrawable, Layer layerModel, List<Layer> layerModels, LottieComposition composition) {
        super(lottieDrawable, layerModel);
        int i;
        AnimatableFloatValue timeRemapping = layerModel.getTimeRemapping();
        if (timeRemapping != null) {
            this.timeRemapping = timeRemapping.createAnimation();
            this.addAnimation(this.timeRemapping);
            this.timeRemapping.addUpdateListener(this);
        } else {
            this.timeRemapping = null;
        }
        LongSparseArray layerMap = new LongSparseArray(composition.getLayers().size());
        BaseLayer mattedLayer = null;
        for (i = layerModels.size() - 1; i >= 0; --i) {
            Layer lm = layerModels.get(i);
            BaseLayer layer = BaseLayer.forModel(lm, lottieDrawable, composition);
            if (layer == null) continue;
            layerMap.put(layer.getLayerModel().getId(), (Object)layer);
            if (mattedLayer != null) {
                mattedLayer.setMatteLayer(layer);
                mattedLayer = null;
                continue;
            }
            this.layers.add(0, layer);
            switch (lm.getMatteType()) {
                case Add: 
                case Invert: {
                    mattedLayer = layer;
                }
            }
        }
        for (i = 0; i < layerMap.size(); ++i) {
            long key = layerMap.keyAt(i);
            BaseLayer layerView = (BaseLayer)layerMap.get(key);
            BaseLayer parentLayer = (BaseLayer)layerMap.get(layerView.getLayerModel().getParentId());
            if (parentLayer == null) continue;
            layerView.setParentLayer(parentLayer);
        }
    }

    @Override
    void drawLayer(Canvas canvas, Matrix parentMatrix, int parentAlpha) {
        L.beginSection("CompositionLayer#draw");
        canvas.getClipBounds(this.originalClipRect);
        this.newClipRect.set(0.0f, 0.0f, (float)this.layerModel.getPreCompWidth(), (float)this.layerModel.getPreCompHeight());
        parentMatrix.mapRect(this.newClipRect);
        for (int i = this.layers.size() - 1; i >= 0; --i) {
            boolean nonEmptyClip = true;
            if (!this.newClipRect.isEmpty()) {
                nonEmptyClip = canvas.clipRect(this.newClipRect);
            }
            if (!nonEmptyClip) continue;
            BaseLayer layer = this.layers.get(i);
            layer.draw(canvas, parentMatrix, parentAlpha);
        }
        if (!this.originalClipRect.isEmpty()) {
            canvas.clipRect(this.originalClipRect, Region.Op.REPLACE);
        }
        L.endSection("CompositionLayer#draw");
    }

    @Override
    public void getBounds(RectF outBounds, Matrix parentMatrix) {
        super.getBounds(outBounds, parentMatrix);
        this.rect.set(0.0f, 0.0f, 0.0f, 0.0f);
        for (int i = this.layers.size() - 1; i >= 0; --i) {
            BaseLayer content = this.layers.get(i);
            content.getBounds(this.rect, this.boundsMatrix);
            if (outBounds.isEmpty()) {
                outBounds.set(this.rect);
                continue;
            }
            outBounds.set(Math.min(outBounds.left, this.rect.left), Math.min(outBounds.top, this.rect.top), Math.max(outBounds.right, this.rect.right), Math.max(outBounds.bottom, this.rect.bottom));
        }
    }

    @Override
    public void setProgress(@FloatRange(from=0.0, to=1.0) float progress) {
        super.setProgress(progress);
        if (this.timeRemapping != null) {
            long duration = this.lottieDrawable.getComposition().getDuration();
            long remappedTime = (long)(((Float)this.timeRemapping.getValue()).floatValue() * 1000.0f);
            progress = (float)remappedTime / (float)duration;
        }
        if (this.layerModel.getTimeStretch() != 0.0f) {
            progress /= this.layerModel.getTimeStretch();
        }
        progress -= this.layerModel.getStartProgress();
        for (int i = this.layers.size() - 1; i >= 0; --i) {
            this.layers.get(i).setProgress(progress);
        }
    }

    boolean hasMasks() {
        if (this.hasMasks == null) {
            for (int i = this.layers.size() - 1; i >= 0; --i) {
                BaseLayer layer = this.layers.get(i);
                if (layer instanceof ShapeLayer) {
                    if (!layer.hasMasksOnThisLayer()) continue;
                    this.hasMasks = true;
                    return true;
                }
                if (!(layer instanceof CompositionLayer) || !((CompositionLayer)layer).hasMasks()) continue;
                this.hasMasks = true;
                return true;
            }
            this.hasMasks = false;
        }
        return this.hasMasks;
    }

    boolean hasMatte() {
        if (this.hasMatte == null) {
            if (this.hasMatteOnThisLayer()) {
                this.hasMatte = true;
                return true;
            }
            for (int i = this.layers.size() - 1; i >= 0; --i) {
                if (!this.layers.get(i).hasMatteOnThisLayer()) continue;
                this.hasMatte = true;
                return true;
            }
            this.hasMatte = false;
        }
        return this.hasMatte;
    }

    @Override
    public void addColorFilter(@Nullable String layerName, @Nullable String contentName, @Nullable ColorFilter colorFilter) {
        for (int i = 0; i < this.layers.size(); ++i) {
            BaseLayer layer = this.layers.get(i);
            String name = layer.getLayerModel().getName();
            if (layerName == null) {
                layer.addColorFilter(null, null, colorFilter);
                continue;
            }
            if (!name.equals(layerName)) continue;
            layer.addColorFilter(layerName, contentName, colorFilter);
        }
    }
}

