/*
 * Decompiled with CFR 0.152.
 */
package com.airbnb.lottie;

import android.graphics.Matrix;
import android.graphics.PointF;
import android.support.annotation.Nullable;
import com.airbnb.lottie.AnimatableTransform;
import com.airbnb.lottie.BaseKeyframeAnimation;
import com.airbnb.lottie.BaseLayer;
import com.airbnb.lottie.KeyframeAnimation;
import com.airbnb.lottie.ScaleXY;

class TransformKeyframeAnimation {
    private final Matrix matrix = new Matrix();
    private final KeyframeAnimation<PointF> anchorPoint;
    private final BaseKeyframeAnimation<?, PointF> position;
    private final KeyframeAnimation<ScaleXY> scale;
    private final KeyframeAnimation<Float> rotation;
    private final KeyframeAnimation<Integer> opacity;
    @Nullable
    private final BaseKeyframeAnimation<?, Float> startOpacity;
    @Nullable
    private final BaseKeyframeAnimation<?, Float> endOpacity;

    TransformKeyframeAnimation(AnimatableTransform animatableTransform) {
        this.anchorPoint = animatableTransform.getAnchorPoint().createAnimation();
        this.position = animatableTransform.getPosition().createAnimation();
        this.scale = animatableTransform.getScale().createAnimation();
        this.rotation = animatableTransform.getRotation().createAnimation();
        this.opacity = animatableTransform.getOpacity().createAnimation();
        this.startOpacity = animatableTransform.getStartOpacity() != null ? animatableTransform.getStartOpacity().createAnimation() : null;
        this.endOpacity = animatableTransform.getEndOpacity() != null ? animatableTransform.getEndOpacity().createAnimation() : null;
    }

    void addAnimationsToLayer(BaseLayer layer) {
        layer.addAnimation(this.anchorPoint);
        layer.addAnimation(this.position);
        layer.addAnimation(this.scale);
        layer.addAnimation(this.rotation);
        layer.addAnimation(this.opacity);
        if (this.startOpacity != null) {
            layer.addAnimation(this.startOpacity);
        }
        if (this.endOpacity != null) {
            layer.addAnimation(this.endOpacity);
        }
    }

    void addListener(BaseKeyframeAnimation.AnimationListener listener) {
        this.anchorPoint.addUpdateListener(listener);
        this.position.addUpdateListener(listener);
        this.scale.addUpdateListener(listener);
        this.rotation.addUpdateListener(listener);
        this.opacity.addUpdateListener(listener);
        if (this.startOpacity != null) {
            this.startOpacity.addUpdateListener(listener);
        }
        if (this.endOpacity != null) {
            this.endOpacity.addUpdateListener(listener);
        }
    }

    BaseKeyframeAnimation<?, Integer> getOpacity() {
        return this.opacity;
    }

    @Nullable
    public BaseKeyframeAnimation<?, Float> getStartOpacity() {
        return this.startOpacity;
    }

    @Nullable
    public BaseKeyframeAnimation<?, Float> getEndOpacity() {
        return this.endOpacity;
    }

    Matrix getMatrix() {
        ScaleXY scaleTransform;
        float rotation;
        this.matrix.reset();
        PointF position = this.position.getValue();
        if (position.x != 0.0f || position.y != 0.0f) {
            this.matrix.preTranslate(position.x, position.y);
        }
        if ((rotation = ((Float)this.rotation.getValue()).floatValue()) != 0.0f) {
            this.matrix.preRotate(rotation);
        }
        if ((scaleTransform = (ScaleXY)this.scale.getValue()).getScaleX() != 1.0f || scaleTransform.getScaleY() != 1.0f) {
            this.matrix.preScale(scaleTransform.getScaleX(), scaleTransform.getScaleY());
        }
        PointF anchorPoint = (PointF)this.anchorPoint.getValue();
        if (anchorPoint.x != 0.0f || anchorPoint.y != 0.0f) {
            this.matrix.preTranslate(-anchorPoint.x, -anchorPoint.y);
        }
        return this.matrix;
    }

    Matrix getMatrixForRepeater(float amount) {
        PointF position = this.position.getValue();
        PointF anchorPoint = (PointF)this.anchorPoint.getValue();
        ScaleXY scale = (ScaleXY)this.scale.getValue();
        float rotation = ((Float)this.rotation.getValue()).floatValue();
        this.matrix.reset();
        this.matrix.preTranslate(position.x * amount, position.y * amount);
        this.matrix.preScale((float)Math.pow(scale.getScaleX(), amount), (float)Math.pow(scale.getScaleY(), amount));
        this.matrix.preRotate(rotation * amount, anchorPoint.x, anchorPoint.y);
        return this.matrix;
    }
}

