/*
 * Decompiled with CFR 0.152.
 */
package com.airbnb.lottie;

import com.airbnb.lottie.GammaEvaluator;
import com.airbnb.lottie.MiscUtils;

class GradientColor {
    private final float[] positions;
    private final int[] colors;

    GradientColor(float[] positions, int[] colors) {
        this.positions = positions;
        this.colors = colors;
    }

    float[] getPositions() {
        return this.positions;
    }

    int[] getColors() {
        return this.colors;
    }

    int getSize() {
        return this.colors.length;
    }

    void lerp(GradientColor gc1, GradientColor gc2, float progress) {
        if (gc1.colors.length != gc2.colors.length) {
            throw new IllegalArgumentException("Cannot interpolate between gradients. Lengths vary (" + gc1.colors.length + " vs " + gc2.colors.length + ")");
        }
        for (int i = 0; i < gc1.colors.length; ++i) {
            this.positions[i] = MiscUtils.lerp(gc1.positions[i], gc2.positions[i], progress);
            this.colors[i] = GammaEvaluator.evaluate(progress, gc1.colors[i], gc2.colors[i]);
        }
    }
}

