/*
 * Decompiled with CFR 0.152.
 */
package com.airbnb.lottie;

import android.graphics.Path;
import android.graphics.PointF;
import android.support.annotation.Nullable;
import com.airbnb.lottie.BaseKeyframeAnimation;
import com.airbnb.lottie.BaseLayer;
import com.airbnb.lottie.Content;
import com.airbnb.lottie.LottieDrawable;
import com.airbnb.lottie.PathContent;
import com.airbnb.lottie.PolystarShape;
import com.airbnb.lottie.ShapeTrimPath;
import com.airbnb.lottie.TrimPathContent;
import com.airbnb.lottie.Utils;
import java.util.List;

class PolystarContent
implements PathContent,
BaseKeyframeAnimation.AnimationListener {
    private static final float POLYSTAR_MAGIC_NUMBER = 0.47829f;
    private static final float POLYGON_MAGIC_NUMBER = 0.25f;
    private final Path path = new Path();
    private final String name;
    private final LottieDrawable lottieDrawable;
    private final PolystarShape.Type type;
    private final BaseKeyframeAnimation<?, Float> pointsAnimation;
    private final BaseKeyframeAnimation<?, PointF> positionAnimation;
    private final BaseKeyframeAnimation<?, Float> rotationAnimation;
    @Nullable
    private final BaseKeyframeAnimation<?, Float> innerRadiusAnimation;
    private final BaseKeyframeAnimation<?, Float> outerRadiusAnimation;
    @Nullable
    private final BaseKeyframeAnimation<?, Float> innerRoundednessAnimation;
    private final BaseKeyframeAnimation<?, Float> outerRoundednessAnimation;
    @Nullable
    private TrimPathContent trimPath;
    private boolean isPathValid;

    PolystarContent(LottieDrawable lottieDrawable, BaseLayer layer, PolystarShape polystarShape) {
        this.lottieDrawable = lottieDrawable;
        this.name = polystarShape.getName();
        this.type = polystarShape.getType();
        this.pointsAnimation = polystarShape.getPoints().createAnimation();
        this.positionAnimation = polystarShape.getPosition().createAnimation();
        this.rotationAnimation = polystarShape.getRotation().createAnimation();
        this.outerRadiusAnimation = polystarShape.getOuterRadius().createAnimation();
        this.outerRoundednessAnimation = polystarShape.getOuterRoundedness().createAnimation();
        if (this.type == PolystarShape.Type.Star) {
            this.innerRadiusAnimation = polystarShape.getInnerRadius().createAnimation();
            this.innerRoundednessAnimation = polystarShape.getInnerRoundedness().createAnimation();
        } else {
            this.innerRadiusAnimation = null;
            this.innerRoundednessAnimation = null;
        }
        layer.addAnimation(this.pointsAnimation);
        layer.addAnimation(this.positionAnimation);
        layer.addAnimation(this.rotationAnimation);
        layer.addAnimation(this.outerRadiusAnimation);
        layer.addAnimation(this.outerRoundednessAnimation);
        if (this.type == PolystarShape.Type.Star) {
            layer.addAnimation(this.innerRadiusAnimation);
            layer.addAnimation(this.innerRoundednessAnimation);
        }
        this.pointsAnimation.addUpdateListener(this);
        this.positionAnimation.addUpdateListener(this);
        this.rotationAnimation.addUpdateListener(this);
        this.outerRadiusAnimation.addUpdateListener(this);
        this.outerRoundednessAnimation.addUpdateListener(this);
        if (this.type == PolystarShape.Type.Star) {
            this.outerRadiusAnimation.addUpdateListener(this);
            this.outerRoundednessAnimation.addUpdateListener(this);
        }
    }

    @Override
    public void onValueChanged() {
        this.invalidate();
    }

    private void invalidate() {
        this.isPathValid = false;
        this.lottieDrawable.invalidateSelf();
    }

    @Override
    public void setContents(List<Content> contentsBefore, List<Content> contentsAfter) {
        for (int i = 0; i < contentsBefore.size(); ++i) {
            Content content = contentsBefore.get(i);
            if (!(content instanceof TrimPathContent) || ((TrimPathContent)content).getType() != ShapeTrimPath.Type.Simultaneously) continue;
            this.trimPath = (TrimPathContent)content;
            this.trimPath.addListener(this);
        }
    }

    @Override
    public Path getPath() {
        if (this.isPathValid) {
            return this.path;
        }
        this.path.reset();
        switch (this.type) {
            case Star: {
                this.createStarPath();
                break;
            }
            case Polygon: {
                this.createPolygonPath();
            }
        }
        this.path.close();
        Utils.applyTrimPathIfNeeded(this.path, this.trimPath);
        this.isPathValid = true;
        return this.path;
    }

    @Override
    public String getName() {
        return this.name;
    }

    private void createStarPath() {
        float y;
        float x;
        float points = this.pointsAnimation.getValue().floatValue();
        double currentAngle = this.rotationAnimation == null ? 0.0 : (double)this.rotationAnimation.getValue().floatValue();
        currentAngle -= 90.0;
        currentAngle = Math.toRadians(currentAngle);
        float anglePerPoint = (float)(Math.PI * 2 / (double)points);
        float halfAnglePerPoint = anglePerPoint / 2.0f;
        float partialPointAmount = points - (float)((int)points);
        if (partialPointAmount != 0.0f) {
            currentAngle += (double)(halfAnglePerPoint * (1.0f - partialPointAmount));
        }
        float outerRadius = this.outerRadiusAnimation.getValue().floatValue();
        float innerRadius = this.innerRadiusAnimation.getValue().floatValue();
        float innerRoundedness = 0.0f;
        if (this.innerRoundednessAnimation != null) {
            innerRoundedness = this.innerRoundednessAnimation.getValue().floatValue() / 100.0f;
        }
        float outerRoundedness = 0.0f;
        if (this.outerRoundednessAnimation != null) {
            outerRoundedness = this.outerRoundednessAnimation.getValue().floatValue() / 100.0f;
        }
        float partialPointRadius = 0.0f;
        if (partialPointAmount != 0.0f) {
            partialPointRadius = innerRadius + partialPointAmount * (outerRadius - innerRadius);
            x = (float)((double)partialPointRadius * Math.cos(currentAngle));
            y = (float)((double)partialPointRadius * Math.sin(currentAngle));
            this.path.moveTo(x, y);
            currentAngle += (double)(anglePerPoint * partialPointAmount / 2.0f);
        } else {
            x = (float)((double)outerRadius * Math.cos(currentAngle));
            y = (float)((double)outerRadius * Math.sin(currentAngle));
            this.path.moveTo(x, y);
            currentAngle += (double)halfAnglePerPoint;
        }
        boolean longSegment = false;
        double numPoints = Math.ceil(points) * 2.0;
        int i = 0;
        while ((double)i < numPoints) {
            float radius = longSegment ? outerRadius : innerRadius;
            float dTheta = halfAnglePerPoint;
            if (partialPointRadius != 0.0f && (double)i == numPoints - 2.0) {
                dTheta = anglePerPoint * partialPointAmount / 2.0f;
            }
            if (partialPointRadius != 0.0f && (double)i == numPoints - 1.0) {
                radius = partialPointRadius;
            }
            float previousX = x;
            float previousY = y;
            x = (float)((double)radius * Math.cos(currentAngle));
            y = (float)((double)radius * Math.sin(currentAngle));
            if (innerRoundedness == 0.0f && outerRoundedness == 0.0f) {
                this.path.lineTo(x, y);
            } else {
                float cp1Theta = (float)(Math.atan2(previousY, previousX) - 1.5707963267948966);
                float cp1Dx = (float)Math.cos(cp1Theta);
                float cp1Dy = (float)Math.sin(cp1Theta);
                float cp2Theta = (float)(Math.atan2(y, x) - 1.5707963267948966);
                float cp2Dx = (float)Math.cos(cp2Theta);
                float cp2Dy = (float)Math.sin(cp2Theta);
                float cp1Roundedness = longSegment ? innerRoundedness : outerRoundedness;
                float cp2Roundedness = longSegment ? outerRoundedness : innerRoundedness;
                float cp1Radius = longSegment ? innerRadius : outerRadius;
                float cp2Radius = longSegment ? outerRadius : innerRadius;
                float cp1x = cp1Radius * cp1Roundedness * 0.47829f * cp1Dx;
                float cp1y = cp1Radius * cp1Roundedness * 0.47829f * cp1Dy;
                float cp2x = cp2Radius * cp2Roundedness * 0.47829f * cp2Dx;
                float cp2y = cp2Radius * cp2Roundedness * 0.47829f * cp2Dy;
                if (partialPointAmount != 0.0f) {
                    if (i == 0) {
                        cp1x *= partialPointAmount;
                        cp1y *= partialPointAmount;
                    } else if ((double)i == numPoints - 1.0) {
                        cp2x *= partialPointAmount;
                        cp2y *= partialPointAmount;
                    }
                }
                this.path.cubicTo(previousX - cp1x, previousY - cp1y, x + cp2x, y + cp2y, x, y);
            }
            currentAngle += (double)dTheta;
            longSegment = !longSegment;
            ++i;
        }
        PointF position = this.positionAnimation.getValue();
        this.path.offset(position.x, position.y);
        this.path.close();
    }

    private void createPolygonPath() {
        int points = (int)Math.floor(this.pointsAnimation.getValue().floatValue());
        double currentAngle = this.rotationAnimation == null ? 0.0 : (double)this.rotationAnimation.getValue().floatValue();
        currentAngle -= 90.0;
        currentAngle = Math.toRadians(currentAngle);
        float anglePerPoint = (float)(Math.PI * 2 / (double)points);
        float roundedness = this.outerRoundednessAnimation.getValue().floatValue() / 100.0f;
        float radius = this.outerRadiusAnimation.getValue().floatValue();
        float x = (float)((double)radius * Math.cos(currentAngle));
        float y = (float)((double)radius * Math.sin(currentAngle));
        this.path.moveTo(x, y);
        currentAngle += (double)anglePerPoint;
        double numPoints = Math.ceil(points);
        int i = 0;
        while ((double)i < numPoints) {
            float previousX = x;
            float previousY = y;
            x = (float)((double)radius * Math.cos(currentAngle));
            y = (float)((double)radius * Math.sin(currentAngle));
            if (roundedness != 0.0f) {
                float cp1Theta = (float)(Math.atan2(previousY, previousX) - 1.5707963267948966);
                float cp1Dx = (float)Math.cos(cp1Theta);
                float cp1Dy = (float)Math.sin(cp1Theta);
                float cp2Theta = (float)(Math.atan2(y, x) - 1.5707963267948966);
                float cp2Dx = (float)Math.cos(cp2Theta);
                float cp2Dy = (float)Math.sin(cp2Theta);
                float cp1x = radius * roundedness * 0.25f * cp1Dx;
                float cp1y = radius * roundedness * 0.25f * cp1Dy;
                float cp2x = radius * roundedness * 0.25f * cp2Dx;
                float cp2y = radius * roundedness * 0.25f * cp2Dy;
                this.path.cubicTo(previousX - cp1x, previousY - cp1y, x + cp2x, y + cp2y, x, y);
            } else {
                this.path.lineTo(x, y);
            }
            currentAngle += (double)anglePerPoint;
            ++i;
        }
        PointF position = this.positionAnimation.getValue();
        this.path.offset(position.x, position.y);
        this.path.close();
    }
}

