/*
 * Decompiled with CFR 0.152.
 */
package com.airbnb.lottie;

import android.graphics.Canvas;
import android.graphics.ColorFilter;
import android.graphics.LinearGradient;
import android.graphics.Matrix;
import android.graphics.PointF;
import android.graphics.RadialGradient;
import android.graphics.RectF;
import android.graphics.Shader;
import android.support.annotation.Nullable;
import android.support.v4.util.LongSparseArray;
import com.airbnb.lottie.BaseLayer;
import com.airbnb.lottie.BaseStrokeContent;
import com.airbnb.lottie.GradientColor;
import com.airbnb.lottie.GradientStroke;
import com.airbnb.lottie.GradientType;
import com.airbnb.lottie.KeyframeAnimation;
import com.airbnb.lottie.LottieDrawable;

public class GradientStrokeContent
extends BaseStrokeContent {
    private static final int CACHE_STEPS_MS = 32;
    private final String name;
    private final LongSparseArray<LinearGradient> linearGradientCache = new LongSparseArray();
    private final LongSparseArray<RadialGradient> radialGradientCache = new LongSparseArray();
    private final RectF boundsRect = new RectF();
    private final GradientType type;
    private final int cacheSteps;
    private final KeyframeAnimation<GradientColor> colorAnimation;
    private final KeyframeAnimation<PointF> startPointAnimation;
    private final KeyframeAnimation<PointF> endPointAnimation;

    GradientStrokeContent(LottieDrawable lottieDrawable, BaseLayer layer, GradientStroke stroke) {
        super(lottieDrawable, layer, stroke.getCapType().toPaintCap(), stroke.getJoinType().toPaintJoin(), stroke.getOpacity(), stroke.getWidth(), stroke.getLineDashPattern(), stroke.getDashOffset());
        this.name = stroke.getName();
        this.type = stroke.getGradientType();
        this.cacheSteps = (int)(lottieDrawable.getComposition().getDuration() / 32L);
        this.colorAnimation = stroke.getGradientColor().createAnimation();
        this.colorAnimation.addUpdateListener(this);
        layer.addAnimation(this.colorAnimation);
        this.startPointAnimation = stroke.getStartPoint().createAnimation();
        this.startPointAnimation.addUpdateListener(this);
        layer.addAnimation(this.startPointAnimation);
        this.endPointAnimation = stroke.getEndPoint().createAnimation();
        this.endPointAnimation.addUpdateListener(this);
        layer.addAnimation(this.endPointAnimation);
    }

    @Override
    public void draw(Canvas canvas, Matrix parentMatrix, int parentAlpha) {
        this.getBounds(this.boundsRect, parentMatrix);
        if (this.type == GradientType.Linear) {
            this.paint.setShader((Shader)this.getLinearGradient());
        } else {
            this.paint.setShader((Shader)this.getRadialGradient());
        }
        super.draw(canvas, parentMatrix, parentAlpha);
    }

    @Override
    public void addColorFilter(@Nullable String layerName, @Nullable String contentName, @Nullable ColorFilter colorFilter) {
    }

    @Override
    public String getName() {
        return this.name;
    }

    private LinearGradient getLinearGradient() {
        int gradientHash = this.getGradientHash();
        LinearGradient gradient = (LinearGradient)this.linearGradientCache.get((long)gradientHash);
        if (gradient != null) {
            return gradient;
        }
        PointF startPoint = (PointF)this.startPointAnimation.getValue();
        PointF endPoint = (PointF)this.endPointAnimation.getValue();
        GradientColor gradientColor = (GradientColor)this.colorAnimation.getValue();
        int[] colors = gradientColor.getColors();
        float[] positions = gradientColor.getPositions();
        int x0 = (int)(this.boundsRect.left + this.boundsRect.width() / 2.0f + startPoint.x);
        int y0 = (int)(this.boundsRect.top + this.boundsRect.height() / 2.0f + startPoint.y);
        int x1 = (int)(this.boundsRect.left + this.boundsRect.width() / 2.0f + endPoint.x);
        int y1 = (int)(this.boundsRect.top + this.boundsRect.height() / 2.0f + endPoint.y);
        gradient = new LinearGradient((float)x0, (float)y0, (float)x1, (float)y1, colors, positions, Shader.TileMode.CLAMP);
        this.linearGradientCache.put((long)gradientHash, (Object)gradient);
        return gradient;
    }

    private RadialGradient getRadialGradient() {
        int gradientHash = this.getGradientHash();
        RadialGradient gradient = (RadialGradient)this.radialGradientCache.get((long)gradientHash);
        if (gradient != null) {
            return gradient;
        }
        PointF startPoint = (PointF)this.startPointAnimation.getValue();
        PointF endPoint = (PointF)this.endPointAnimation.getValue();
        GradientColor gradientColor = (GradientColor)this.colorAnimation.getValue();
        int[] colors = gradientColor.getColors();
        float[] positions = gradientColor.getPositions();
        int x0 = (int)(this.boundsRect.left + this.boundsRect.width() / 2.0f + startPoint.x);
        int y0 = (int)(this.boundsRect.top + this.boundsRect.height() / 2.0f + startPoint.y);
        int x1 = (int)(this.boundsRect.left + this.boundsRect.width() / 2.0f + endPoint.x);
        int y1 = (int)(this.boundsRect.top + this.boundsRect.height() / 2.0f + endPoint.y);
        float r = (float)Math.hypot(x1 - x0, y1 - y0);
        gradient = new RadialGradient((float)x0, (float)y0, r, colors, positions, Shader.TileMode.CLAMP);
        this.radialGradientCache.put((long)gradientHash, (Object)gradient);
        return gradient;
    }

    private int getGradientHash() {
        int startPointProgress = Math.round(this.startPointAnimation.getProgress() * (float)this.cacheSteps);
        int endPointProgress = Math.round(this.endPointAnimation.getProgress() * (float)this.cacheSteps);
        int colorProgress = Math.round(this.colorAnimation.getProgress() * (float)this.cacheSteps);
        int hash = 17;
        hash = hash * 31 * startPointProgress;
        hash = hash * 31 * endPointProgress;
        hash = hash * 31 * colorProgress;
        return hash;
    }
}

