/*
 * Decompiled with CFR 0.152.
 */
package com.airbnb.lottie;

import android.graphics.Canvas;
import android.graphics.ColorFilter;
import android.graphics.Matrix;
import android.graphics.RectF;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.airbnb.lottie.BaseLayer;
import com.airbnb.lottie.ContentGroup;
import com.airbnb.lottie.Layer;
import com.airbnb.lottie.LottieDrawable;
import com.airbnb.lottie.ShapeGroup;
import java.util.Collections;

class ShapeLayer
extends BaseLayer {
    private final Matrix matrix = new Matrix();
    private final ContentGroup contentGroup;

    ShapeLayer(LottieDrawable lottieDrawable, Layer layerModel) {
        super(lottieDrawable, layerModel);
        ShapeGroup shapeGroup = new ShapeGroup(layerModel.getName(), layerModel.getShapes());
        this.contentGroup = new ContentGroup(lottieDrawable, this, shapeGroup);
        this.contentGroup.setContents(Collections.emptyList(), Collections.emptyList());
    }

    @Override
    void drawLayer(@NonNull Canvas canvas, Matrix parentMatrix, int parentAlpha) {
        this.contentGroup.draw(canvas, parentMatrix, parentAlpha);
    }

    @Override
    public void getBounds(RectF outBounds, Matrix parentMatrix) {
        super.getBounds(outBounds, parentMatrix);
        this.contentGroup.getBounds(outBounds, this.boundsMatrix);
    }

    @Override
    public void addColorFilter(@Nullable String layerName, @Nullable String contentName, @Nullable ColorFilter colorFilter) {
        this.contentGroup.addColorFilter(layerName, contentName, colorFilter);
    }
}

