/*
 * Decompiled with CFR 0.152.
 */
package com.airbnb.lottie;

import android.graphics.Canvas;
import android.graphics.ColorFilter;
import android.graphics.Matrix;
import android.graphics.RectF;
import android.support.annotation.FloatRange;
import android.support.annotation.Nullable;
import android.support.v4.util.LongSparseArray;
import com.airbnb.lottie.BaseLayer;
import com.airbnb.lottie.Layer;
import com.airbnb.lottie.LottieComposition;
import com.airbnb.lottie.LottieDrawable;
import com.airbnb.lottie.ShapeLayer;
import java.util.ArrayList;
import java.util.List;

class CompositionLayer
extends BaseLayer {
    private final List<BaseLayer> layers = new ArrayList<BaseLayer>();
    private final RectF rect = new RectF();

    CompositionLayer(LottieDrawable lottieDrawable, Layer layerModel, List<Layer> layerModels, LottieComposition composition) {
        super(lottieDrawable, layerModel);
        int i;
        LongSparseArray layerMap = new LongSparseArray(composition.getLayers().size());
        BaseLayer mattedLayer = null;
        for (i = layerModels.size() - 1; i >= 0; --i) {
            Layer lm = layerModels.get(i);
            BaseLayer layer = BaseLayer.forModel(lm, lottieDrawable, composition);
            if (layer == null) continue;
            layerMap.put(layer.getLayerModel().getId(), (Object)layer);
            if (mattedLayer != null) {
                mattedLayer.setMatteLayer(layer);
                mattedLayer = null;
                continue;
            }
            this.layers.add(0, layer);
            switch (lm.getMatteType()) {
                case Add: 
                case Invert: {
                    mattedLayer = layer;
                }
            }
        }
        for (i = 0; i < layerMap.size(); ++i) {
            long key = layerMap.keyAt(i);
            BaseLayer layerView = (BaseLayer)layerMap.get(key);
            BaseLayer parentLayer = (BaseLayer)layerMap.get(layerView.getLayerModel().getParentId());
            if (parentLayer == null) continue;
            layerView.setParentLayer(parentLayer);
        }
    }

    @Override
    void drawLayer(Canvas canvas, Matrix parentMatrix, int parentAlpha) {
        for (int i = this.layers.size() - 1; i >= 0; --i) {
            this.layers.get(i).draw(canvas, parentMatrix, parentAlpha);
        }
    }

    @Override
    public void getBounds(RectF outBounds, Matrix parentMatrix) {
        super.getBounds(outBounds, parentMatrix);
        this.rect.set(0.0f, 0.0f, 0.0f, 0.0f);
        for (int i = this.layers.size() - 1; i >= 0; --i) {
            BaseLayer content = this.layers.get(i);
            content.getBounds(this.rect, this.boundsMatrix);
            if (outBounds.isEmpty()) {
                outBounds.set(this.rect);
                continue;
            }
            outBounds.set(Math.min(outBounds.left, this.rect.left), Math.min(outBounds.top, this.rect.top), Math.max(outBounds.right, this.rect.right), Math.max(outBounds.bottom, this.rect.bottom));
        }
    }

    @Override
    public void setProgress(@FloatRange(from=0.0, to=1.0) float progress) {
        super.setProgress(progress);
        progress -= this.layerModel.getStartProgress();
        for (int i = this.layers.size() - 1; i >= 0; --i) {
            this.layers.get(i).setProgress(progress);
        }
    }

    boolean hasMasks() {
        for (int i = this.layers.size() - 1; i >= 0; --i) {
            BaseLayer layer = this.layers.get(i);
            if (!(layer instanceof ShapeLayer) || !layer.hasMasksOnThisLayer()) continue;
            return true;
        }
        return false;
    }

    boolean hasMatte() {
        if (this.hasMatteOnThisLayer()) {
            return true;
        }
        for (int i = this.layers.size() - 1; i >= 0; --i) {
            if (!this.layers.get(i).hasMatteOnThisLayer()) continue;
            return true;
        }
        return false;
    }

    @Override
    public void addColorFilter(@Nullable String layerName, @Nullable String contentName, @Nullable ColorFilter colorFilter) {
        for (int i = 0; i < this.layers.size(); ++i) {
            BaseLayer layer = this.layers.get(i);
            String name = layer.getLayerModel().getName();
            if (layerName == null) {
                layer.addColorFilter(null, null, colorFilter);
                continue;
            }
            if (!name.equals(layerName)) continue;
            layer.addColorFilter(layerName, contentName, colorFilter);
        }
    }
}

