/*
 * Decompiled with CFR 0.152.
 */
package com.airbnb.lottie;

import android.graphics.Canvas;
import android.graphics.LinearGradient;
import android.graphics.Matrix;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.PointF;
import android.graphics.RadialGradient;
import android.graphics.RectF;
import android.graphics.Shader;
import android.support.v4.util.LongSparseArray;
import com.airbnb.lottie.BaseKeyframeAnimation;
import com.airbnb.lottie.BaseLayer;
import com.airbnb.lottie.Content;
import com.airbnb.lottie.DrawingContent;
import com.airbnb.lottie.GradientColor;
import com.airbnb.lottie.GradientFill;
import com.airbnb.lottie.KeyframeAnimation;
import com.airbnb.lottie.LottieDrawable;
import com.airbnb.lottie.PathContent;
import java.util.ArrayList;
import java.util.List;

class GradientFillContent
implements DrawingContent,
BaseKeyframeAnimation.AnimationListener {
    private static final int CACHE_STEPS_MS = 32;
    private final LongSparseArray<LinearGradient> linearGradientCache = new LongSparseArray();
    private final LongSparseArray<RadialGradient> radialGradientCache = new LongSparseArray();
    private final Path path = new Path();
    private final Paint paint = new Paint(1);
    private final RectF boundsRect = new RectF();
    private final List<PathContent> paths = new ArrayList<PathContent>();
    private final GradientFill.GradientType type;
    private final KeyframeAnimation<GradientColor> colorAnimation;
    private final KeyframeAnimation<Integer> opacityAnimation;
    private final KeyframeAnimation<PointF> startPointAnimation;
    private final KeyframeAnimation<PointF> endPointAnimation;
    private final LottieDrawable lottieDrawable;
    private final int cacheSteps;

    GradientFillContent(LottieDrawable lottieDrawable, BaseLayer layer, GradientFill fill) {
        this.lottieDrawable = lottieDrawable;
        this.type = fill.getGradientType();
        this.path.setFillType(fill.getFillType());
        this.cacheSteps = (int)(lottieDrawable.getComposition().getDuration() / 32L);
        this.colorAnimation = fill.getGradientColor().createAnimation();
        this.colorAnimation.addUpdateListener(this);
        layer.addAnimation(this.colorAnimation);
        this.opacityAnimation = fill.getOpacity().createAnimation();
        this.opacityAnimation.addUpdateListener(this);
        layer.addAnimation(this.opacityAnimation);
        this.startPointAnimation = fill.getStartPoint().createAnimation();
        this.startPointAnimation.addUpdateListener(this);
        layer.addAnimation(this.startPointAnimation);
        this.endPointAnimation = fill.getEndPoint().createAnimation();
        this.endPointAnimation.addUpdateListener(this);
        layer.addAnimation(this.endPointAnimation);
    }

    @Override
    public void onValueChanged() {
        this.lottieDrawable.invalidateSelf();
    }

    @Override
    public void setContents(List<Content> contentsBefore, List<Content> contentsAfter) {
        for (int i = 0; i < contentsAfter.size(); ++i) {
            Content content = contentsAfter.get(i);
            if (!(content instanceof PathContent)) continue;
            this.paths.add((PathContent)content);
        }
    }

    @Override
    public void draw(Canvas canvas, Matrix parentMatrix, int parentAlpha) {
        this.path.reset();
        for (int i = 0; i < this.paths.size(); ++i) {
            this.path.addPath(this.paths.get(i).getPath(), parentMatrix);
        }
        this.path.computeBounds(this.boundsRect, false);
        if (this.type == GradientFill.GradientType.Linear) {
            this.paint.setShader((Shader)this.getLinearGradient());
        } else {
            this.paint.setShader((Shader)this.getRadialGradient());
        }
        int alpha = (int)((float)parentAlpha / 255.0f * (float)((Integer)this.opacityAnimation.getValue()).intValue() / 100.0f * 255.0f);
        this.paint.setAlpha(alpha);
        canvas.drawPath(this.path, this.paint);
    }

    @Override
    public void getBounds(RectF outBounds, Matrix parentMatrix) {
        this.path.reset();
        for (int i = 0; i < this.paths.size(); ++i) {
            this.path.addPath(this.paths.get(i).getPath(), parentMatrix);
        }
        this.path.computeBounds(outBounds, false);
        outBounds.set(outBounds.left - 1.0f, outBounds.top - 1.0f, outBounds.right + 1.0f, outBounds.bottom + 1.0f);
    }

    private LinearGradient getLinearGradient() {
        int gradientHash = this.getGradientHash();
        LinearGradient gradient = (LinearGradient)this.linearGradientCache.get((long)gradientHash);
        if (gradient != null) {
            return gradient;
        }
        PointF startPoint = (PointF)this.startPointAnimation.getValue();
        PointF endPoint = (PointF)this.endPointAnimation.getValue();
        GradientColor gradientColor = (GradientColor)this.colorAnimation.getValue();
        int[] colors = gradientColor.getColors();
        float[] positions = gradientColor.getPositions();
        int x0 = (int)(this.boundsRect.left + this.boundsRect.width() / 2.0f + startPoint.x);
        int y0 = (int)(this.boundsRect.top + this.boundsRect.height() / 2.0f + startPoint.y);
        int x1 = (int)(this.boundsRect.left + this.boundsRect.width() / 2.0f + endPoint.x);
        int y1 = (int)(this.boundsRect.top + this.boundsRect.height() / 2.0f + endPoint.y);
        gradient = new LinearGradient((float)x0, (float)y0, (float)x1, (float)y1, colors, positions, Shader.TileMode.CLAMP);
        this.linearGradientCache.put((long)gradientHash, (Object)gradient);
        return gradient;
    }

    private RadialGradient getRadialGradient() {
        int gradientHash = this.getGradientHash();
        RadialGradient gradient = (RadialGradient)this.radialGradientCache.get((long)gradientHash);
        if (gradient != null) {
            return gradient;
        }
        PointF startPoint = (PointF)this.startPointAnimation.getValue();
        PointF endPoint = (PointF)this.endPointAnimation.getValue();
        GradientColor gradientColor = (GradientColor)this.colorAnimation.getValue();
        int[] colors = gradientColor.getColors();
        float[] positions = gradientColor.getPositions();
        int x0 = (int)(this.boundsRect.left + this.boundsRect.width() / 2.0f + startPoint.x);
        int y0 = (int)(this.boundsRect.top + this.boundsRect.height() / 2.0f + startPoint.y);
        int x1 = (int)(this.boundsRect.left + this.boundsRect.width() / 2.0f + endPoint.x);
        int y1 = (int)(this.boundsRect.top + this.boundsRect.height() / 2.0f + endPoint.y);
        float r = (float)Math.hypot(x1 - x0, y1 - y0);
        gradient = new RadialGradient((float)x0, (float)y0, r, colors, positions, Shader.TileMode.CLAMP);
        this.radialGradientCache.put((long)gradientHash, (Object)gradient);
        return gradient;
    }

    private int getGradientHash() {
        int startPointProgress = Math.round(this.startPointAnimation.getProgress() * (float)this.cacheSteps);
        int endPointProgress = Math.round(this.endPointAnimation.getProgress() * (float)this.cacheSteps);
        int colorProgress = Math.round(this.colorAnimation.getProgress() * (float)this.cacheSteps);
        int hash = 17;
        hash = hash * 31 * startPointProgress;
        hash = hash * 31 * endPointProgress;
        hash = hash * 31 * colorProgress;
        return hash;
    }
}

