/*
 * Decompiled with CFR 0.152.
 */
package com.airbnb.lottie;

import android.graphics.Paint;
import android.support.annotation.Nullable;
import com.airbnb.lottie.AnimatableColorValue;
import com.airbnb.lottie.AnimatableFloatValue;
import com.airbnb.lottie.AnimatableIntegerValue;
import com.airbnb.lottie.LottieComposition;
import java.util.ArrayList;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONObject;

class ShapeStroke {
    @Nullable
    private final AnimatableFloatValue offset;
    private final List<AnimatableFloatValue> lineDashPattern;
    private final AnimatableColorValue color;
    private final AnimatableIntegerValue opacity;
    private final AnimatableFloatValue width;
    private final LineCapType capType;
    private final LineJoinType joinType;

    private ShapeStroke(@Nullable AnimatableFloatValue offset, List<AnimatableFloatValue> lineDashPattern, AnimatableColorValue color, AnimatableIntegerValue opacity, AnimatableFloatValue width, LineCapType capType, LineJoinType joinType) {
        this.offset = offset;
        this.lineDashPattern = lineDashPattern;
        this.color = color;
        this.opacity = opacity;
        this.width = width;
        this.capType = capType;
        this.joinType = joinType;
    }

    AnimatableColorValue getColor() {
        return this.color;
    }

    AnimatableIntegerValue getOpacity() {
        return this.opacity;
    }

    AnimatableFloatValue getWidth() {
        return this.width;
    }

    List<AnimatableFloatValue> getLineDashPattern() {
        return this.lineDashPattern;
    }

    AnimatableFloatValue getDashOffset() {
        return this.offset;
    }

    LineCapType getCapType() {
        return this.capType;
    }

    LineJoinType getJoinType() {
        return this.joinType;
    }

    static class Factory {
        private Factory() {
        }

        static ShapeStroke newInstance(JSONObject json, LottieComposition composition) {
            ArrayList<AnimatableFloatValue> lineDashPattern = new ArrayList<AnimatableFloatValue>();
            AnimatableColorValue color = AnimatableColorValue.Factory.newInstance(json.optJSONObject("c"), composition);
            AnimatableFloatValue width = AnimatableFloatValue.Factory.newInstance(json.optJSONObject("w"), composition);
            AnimatableIntegerValue opacity = AnimatableIntegerValue.Factory.newInstance(json.optJSONObject("o"), composition);
            LineCapType capType = LineCapType.values()[json.optInt("lc") - 1];
            LineJoinType joinType = LineJoinType.values()[json.optInt("lj") - 1];
            AnimatableFloatValue offset = null;
            if (json.has("d")) {
                JSONArray dashesJson = json.optJSONArray("d");
                for (int i = 0; i < dashesJson.length(); ++i) {
                    JSONObject value;
                    JSONObject dashJson = dashesJson.optJSONObject(i);
                    String n = dashJson.optString("n");
                    if (n.equals("o")) {
                        value = dashJson.optJSONObject("v");
                        offset = AnimatableFloatValue.Factory.newInstance(value, composition);
                        continue;
                    }
                    if (!n.equals("d") && !n.equals("g")) continue;
                    value = dashJson.optJSONObject("v");
                    lineDashPattern.add(AnimatableFloatValue.Factory.newInstance(value, composition));
                }
                if (lineDashPattern.size() == 1) {
                    lineDashPattern.add((AnimatableFloatValue)lineDashPattern.get(0));
                }
            }
            return new ShapeStroke(offset, lineDashPattern, color, opacity, width, capType, joinType);
        }
    }

    static enum LineJoinType {
        Miter,
        Round,
        Bevel;


        Paint.Join toPaintJoin() {
            switch (this) {
                case Bevel: {
                    return Paint.Join.BEVEL;
                }
                case Miter: {
                    return Paint.Join.MITER;
                }
                case Round: {
                    return Paint.Join.ROUND;
                }
            }
            return null;
        }
    }

    static enum LineCapType {
        Butt,
        Round,
        Unknown;


        Paint.Cap toPaintCap() {
            switch (this) {
                case Butt: {
                    return Paint.Cap.BUTT;
                }
                case Round: {
                    return Paint.Cap.ROUND;
                }
            }
            return Paint.Cap.SQUARE;
        }
    }
}

