/*
 * Decompiled with CFR 0.152.
 */
package com.airbnb.lottie;

import android.animation.Animator;
import android.animation.TimeInterpolator;
import android.animation.ValueAnimator;
import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.ColorFilter;
import android.graphics.Matrix;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.support.annotation.FloatRange;
import android.support.annotation.IntRange;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.util.Log;
import android.view.View;
import android.view.animation.LinearInterpolator;
import com.airbnb.lottie.CompositionLayer;
import com.airbnb.lottie.ImageAssetBitmapManager;
import com.airbnb.lottie.ImageAssetDelegate;
import com.airbnb.lottie.Layer;
import com.airbnb.lottie.LottieComposition;

public class LottieDrawable
extends Drawable
implements Drawable.Callback {
    private static final String TAG = LottieDrawable.class.getSimpleName();
    private final Matrix matrix = new Matrix();
    private LottieComposition composition;
    private final ValueAnimator animator = ValueAnimator.ofFloat((float[])new float[]{0.0f, 1.0f});
    private float speed = 1.0f;
    private float scale = 1.0f;
    private float progress = 0.0f;
    @Nullable
    private ImageAssetBitmapManager imageAssetBitmapManager;
    @Nullable
    private String imageAssetsFolder;
    @Nullable
    private ImageAssetDelegate imageAssetDelegate;
    private boolean playAnimationWhenCompositionAdded;
    private boolean reverseAnimationWhenCompositionAdded;
    private boolean systemAnimationsAreDisabled;
    private boolean enableMergePaths;
    @Nullable
    private CompositionLayer compositionLayer;
    private int alpha = 255;

    public LottieDrawable() {
        this.animator.setRepeatCount(0);
        this.animator.setInterpolator((TimeInterpolator)new LinearInterpolator());
        this.animator.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

            public void onAnimationUpdate(ValueAnimator animation) {
                if (LottieDrawable.this.systemAnimationsAreDisabled) {
                    LottieDrawable.this.animator.cancel();
                    LottieDrawable.this.setProgress(1.0f);
                } else {
                    LottieDrawable.this.setProgress(((Float)animation.getAnimatedValue()).floatValue());
                }
            }
        });
    }

    public boolean hasMasks() {
        return this.compositionLayer != null && this.compositionLayer.hasMasks();
    }

    public boolean hasMatte() {
        return this.compositionLayer != null && this.compositionLayer.hasMatte();
    }

    boolean enableMergePathsForKitKatAndAbove() {
        return this.enableMergePaths;
    }

    public void enableMergePathsForKitKatAndAbove(boolean enable) {
        if (Build.VERSION.SDK_INT < 19) {
            Log.w((String)TAG, (String)"Merge paths are not supported pre-Kit Kat.");
            return;
        }
        this.enableMergePaths = enable;
        if (this.composition != null) {
            this.buildCompositionLayer();
        }
    }

    public void setImagesAssetsFolder(@Nullable String imageAssetsFolder) {
        this.imageAssetsFolder = imageAssetsFolder;
    }

    public void recycleBitmaps() {
        if (this.imageAssetBitmapManager != null) {
            this.imageAssetBitmapManager.recycleBitmaps();
        }
    }

    public boolean setComposition(LottieComposition composition) {
        if (this.getCallback() == null) {
            throw new IllegalStateException("You or your view must set a Drawable.Callback before setting the composition. This gets done automatically when added to an ImageView. Either call ImageView.setImageDrawable() before setComposition() or call setCallback(yourView.getCallback()) first.");
        }
        if (this.composition == composition) {
            return false;
        }
        this.clearComposition();
        this.composition = composition;
        this.setSpeed(this.speed);
        this.setScale(1.0f);
        this.updateBounds();
        this.buildCompositionLayer();
        this.setProgress(this.progress);
        if (this.playAnimationWhenCompositionAdded) {
            this.playAnimationWhenCompositionAdded = false;
            this.playAnimation();
        }
        if (this.reverseAnimationWhenCompositionAdded) {
            this.reverseAnimationWhenCompositionAdded = false;
            this.reverseAnimation();
        }
        return true;
    }

    private void buildCompositionLayer() {
        this.compositionLayer = new CompositionLayer(this, Layer.Factory.newInstance(this.composition), this.composition.getLayers(), this.composition);
    }

    private void clearComposition() {
        this.recycleBitmaps();
        this.compositionLayer = null;
        this.imageAssetBitmapManager = null;
        this.invalidateSelf();
    }

    public void invalidateSelf() {
        Drawable.Callback callback = this.getCallback();
        if (callback != null) {
            callback.invalidateDrawable((Drawable)this);
        }
    }

    public void setAlpha(@IntRange(from=0L, to=255L) int alpha) {
        this.alpha = alpha;
    }

    public int getAlpha() {
        return this.alpha;
    }

    public void setColorFilter(@Nullable ColorFilter colorFilter) {
    }

    public int getOpacity() {
        return -3;
    }

    public void draw(@NonNull Canvas canvas) {
        if (this.compositionLayer == null) {
            return;
        }
        this.matrix.reset();
        this.matrix.preScale(this.scale, this.scale);
        this.compositionLayer.draw(canvas, this.matrix, this.alpha);
    }

    void systemAnimationsAreDisabled() {
        this.systemAnimationsAreDisabled = true;
    }

    public void loop(boolean loop) {
        this.animator.setRepeatCount(loop ? -1 : 0);
    }

    public boolean isLooping() {
        return this.animator.getRepeatCount() == -1;
    }

    public boolean isAnimating() {
        return this.animator.isRunning();
    }

    public void playAnimation() {
        this.playAnimation(false);
    }

    public void resumeAnimation() {
        this.playAnimation(true);
    }

    private void playAnimation(boolean setStartTime) {
        if (this.compositionLayer == null) {
            this.playAnimationWhenCompositionAdded = true;
            this.reverseAnimationWhenCompositionAdded = false;
            return;
        }
        if (setStartTime) {
            this.animator.setCurrentPlayTime((long)(this.progress * (float)this.animator.getDuration()));
        }
        this.animator.start();
    }

    public void resumeReverseAnimation() {
        this.reverseAnimation(true);
    }

    public void reverseAnimation() {
        this.reverseAnimation(false);
    }

    private void reverseAnimation(boolean setStartTime) {
        if (this.compositionLayer == null) {
            this.playAnimationWhenCompositionAdded = false;
            this.reverseAnimationWhenCompositionAdded = true;
            return;
        }
        if (setStartTime) {
            this.animator.setCurrentPlayTime((long)(this.progress * (float)this.animator.getDuration()));
        }
        this.animator.reverse();
    }

    public void setSpeed(float speed) {
        this.speed = speed;
        if (speed < 0.0f) {
            this.animator.setFloatValues(new float[]{1.0f, 0.0f});
        } else {
            this.animator.setFloatValues(new float[]{0.0f, 1.0f});
        }
        if (this.composition != null) {
            this.animator.setDuration((long)((float)this.composition.getDuration() / Math.abs(speed)));
        }
    }

    public void setProgress(@FloatRange(from=0.0, to=1.0) float progress) {
        this.progress = progress;
        if (this.compositionLayer != null) {
            this.compositionLayer.setProgress(progress);
        }
    }

    public float getProgress() {
        return this.progress;
    }

    public void setScale(float scale) {
        this.scale = scale;
        this.updateBounds();
    }

    public void setImageAssetDelegate(ImageAssetDelegate assetDelegate) {
        this.imageAssetDelegate = assetDelegate;
        if (this.imageAssetBitmapManager != null) {
            this.imageAssetBitmapManager.setAssetDelegate(assetDelegate);
        }
    }

    public float getScale() {
        return this.scale;
    }

    public LottieComposition getComposition() {
        return this.composition;
    }

    private void updateBounds() {
        if (this.composition == null) {
            return;
        }
        this.setBounds(0, 0, (int)((float)this.composition.getBounds().width() * this.scale), (int)((float)this.composition.getBounds().height() * this.scale));
    }

    public void cancelAnimation() {
        this.playAnimationWhenCompositionAdded = false;
        this.reverseAnimationWhenCompositionAdded = false;
        this.animator.cancel();
    }

    public void addAnimatorUpdateListener(ValueAnimator.AnimatorUpdateListener updateListener) {
        this.animator.addUpdateListener(updateListener);
    }

    public void removeAnimatorUpdateListener(ValueAnimator.AnimatorUpdateListener updateListener) {
        this.animator.removeUpdateListener(updateListener);
    }

    public void addAnimatorListener(Animator.AnimatorListener listener) {
        this.animator.addListener(listener);
    }

    public void removeAnimatorListener(Animator.AnimatorListener listener) {
        this.animator.removeListener(listener);
    }

    public int getIntrinsicWidth() {
        return this.composition == null ? -1 : (int)((float)this.composition.getBounds().width() * this.scale);
    }

    public int getIntrinsicHeight() {
        return this.composition == null ? -1 : (int)((float)this.composition.getBounds().height() * this.scale);
    }

    Bitmap getImageAsset(String id) {
        return this.getImageAssetBitmapManager().bitmapForId(id);
    }

    private ImageAssetBitmapManager getImageAssetBitmapManager() {
        if (this.imageAssetBitmapManager != null && !this.imageAssetBitmapManager.hasSameContext(this.getContext())) {
            this.imageAssetBitmapManager.recycleBitmaps();
            this.imageAssetBitmapManager = null;
        }
        if (this.imageAssetBitmapManager == null) {
            this.imageAssetBitmapManager = new ImageAssetBitmapManager(this.getCallback(), this.imageAssetsFolder, this.imageAssetDelegate, this.composition.getImages());
        }
        return this.imageAssetBitmapManager;
    }

    @Nullable
    private Context getContext() {
        Drawable.Callback callback = this.getCallback();
        if (callback == null) {
            return null;
        }
        if (callback instanceof View) {
            return ((View)callback).getContext();
        }
        return null;
    }

    public void invalidateDrawable(@NonNull Drawable who) {
        Drawable.Callback callback = this.getCallback();
        if (callback == null) {
            return;
        }
        callback.invalidateDrawable((Drawable)this);
    }

    public void scheduleDrawable(@NonNull Drawable who, @NonNull Runnable what, long when) {
        Drawable.Callback callback = this.getCallback();
        if (callback == null) {
            return;
        }
        callback.scheduleDrawable((Drawable)this, what, when);
    }

    public void unscheduleDrawable(@NonNull Drawable who, @NonNull Runnable what) {
        Drawable.Callback callback = this.getCallback();
        if (callback == null) {
            return;
        }
        callback.unscheduleDrawable((Drawable)this, what);
    }
}

