/*
 * Decompiled with CFR 0.152.
 */
package com.airbnb.lottie;

import android.graphics.PointF;
import com.airbnb.lottie.AnimatableFloatValue;
import com.airbnb.lottie.AnimatableIntegerValue;
import com.airbnb.lottie.AnimatablePathValue;
import com.airbnb.lottie.AnimatableScaleValue;
import com.airbnb.lottie.AnimatableValue;
import com.airbnb.lottie.LottieComposition;
import com.airbnb.lottie.ModifierContent;
import com.airbnb.lottie.ScaleXY;
import com.airbnb.lottie.TransformKeyframeAnimation;
import java.util.Collections;
import org.json.JSONObject;

class AnimatableTransform
implements ModifierContent {
    private final AnimatablePathValue anchorPoint;
    private final AnimatableValue<PointF> position;
    private final AnimatableScaleValue scale;
    private final AnimatableFloatValue rotation;
    private final AnimatableIntegerValue opacity;

    private AnimatableTransform(AnimatablePathValue anchorPoint, AnimatableValue<PointF> position, AnimatableScaleValue scale, AnimatableFloatValue rotation, AnimatableIntegerValue opacity) {
        this.anchorPoint = anchorPoint;
        this.position = position;
        this.scale = scale;
        this.rotation = rotation;
        this.opacity = opacity;
    }

    AnimatablePathValue getAnchorPoint() {
        return this.anchorPoint;
    }

    AnimatableValue<PointF> getPosition() {
        return this.position;
    }

    AnimatableScaleValue getScale() {
        return this.scale;
    }

    AnimatableFloatValue getRotation() {
        return this.rotation;
    }

    AnimatableIntegerValue getOpacity() {
        return this.opacity;
    }

    public TransformKeyframeAnimation createAnimation() {
        return new TransformKeyframeAnimation(this);
    }

    static class Factory {
        private Factory() {
        }

        static AnimatableTransform newInstance() {
            AnimatablePathValue anchorPoint = new AnimatablePathValue();
            AnimatablePathValue position = new AnimatablePathValue();
            AnimatableScaleValue scale = AnimatableScaleValue.Factory.newInstance();
            AnimatableFloatValue rotation = AnimatableFloatValue.Factory.newInstance();
            AnimatableIntegerValue opacity = AnimatableIntegerValue.Factory.newInstance();
            return new AnimatableTransform(anchorPoint, position, scale, rotation, opacity);
        }

        static AnimatableTransform newInstance(JSONObject json, LottieComposition composition) {
            AnimatablePathValue anchorPoint = null;
            AnimatableValue<PointF> position = null;
            AnimatableFloatValue rotation = null;
            JSONObject anchorJson = json.optJSONObject("a");
            if (anchorJson != null) {
                anchorPoint = new AnimatablePathValue(anchorJson.opt("k"), composition);
            } else {
                Factory.throwMissingTransform("anchor");
            }
            JSONObject positionJson = json.optJSONObject("p");
            if (positionJson != null) {
                position = AnimatablePathValue.createAnimatablePathOrSplitDimensionPath(positionJson, composition);
            } else {
                Factory.throwMissingTransform("position");
            }
            JSONObject scaleJson = json.optJSONObject("s");
            AnimatableScaleValue scale = scaleJson != null ? AnimatableScaleValue.Factory.newInstance(scaleJson, composition) : new AnimatableScaleValue(Collections.emptyList(), new ScaleXY());
            JSONObject rotationJson = json.optJSONObject("r");
            if (rotationJson == null) {
                rotationJson = json.optJSONObject("rz");
            }
            if (rotationJson != null) {
                rotation = AnimatableFloatValue.Factory.newInstance(rotationJson, composition, false);
            } else {
                Factory.throwMissingTransform("rotation");
            }
            JSONObject opacityJson = json.optJSONObject("o");
            AnimatableIntegerValue opacity = opacityJson != null ? AnimatableIntegerValue.Factory.newInstance(opacityJson, composition) : new AnimatableIntegerValue(Collections.emptyList(), 100);
            return new AnimatableTransform(anchorPoint, position, scale, rotation, opacity);
        }

        private static void throwMissingTransform(String missingProperty) {
            throw new IllegalArgumentException("Missing transform for " + missingProperty);
        }
    }
}

