/*
 * Decompiled with CFR 0.152.
 */
package com.airbnb.lottie;

import android.graphics.Color;
import com.airbnb.lottie.AnimatableValue;
import com.airbnb.lottie.AnimatableValueParser;
import com.airbnb.lottie.BaseAnimatableValue;
import com.airbnb.lottie.GradientColor;
import com.airbnb.lottie.GradientColorKeyframeAnimation;
import com.airbnb.lottie.Keyframe;
import com.airbnb.lottie.KeyframeAnimation;
import com.airbnb.lottie.LottieComposition;
import com.airbnb.lottie.StaticKeyframeAnimation;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONObject;

class AnimatableGradientColorValue
extends BaseAnimatableValue<GradientColor, GradientColor> {
    private AnimatableGradientColorValue(List<Keyframe<GradientColor>> keyframes, GradientColor initialValue) {
        super(keyframes, initialValue);
    }

    public KeyframeAnimation<GradientColor> createAnimation() {
        if (!this.hasAnimation()) {
            return new StaticKeyframeAnimation<Object>(this.initialValue);
        }
        return new GradientColorKeyframeAnimation(this.keyframes);
    }

    private static class ValueFactory
    implements AnimatableValue.Factory<GradientColor> {
        private static final ValueFactory INSTANCE = new ValueFactory();

        private ValueFactory() {
        }

        @Override
        public GradientColor valueFromObject(Object object, float scale) {
            JSONArray array = (JSONArray)object;
            int size = array.length() / 4;
            float[] positions = new float[size];
            int[] colors = new int[size];
            GradientColor gradientColor = new GradientColor(positions, colors);
            int r = 0;
            int g = 0;
            block6: for (int i = 0; i < array.length(); ++i) {
                int colorIndex = i / 4;
                double value = array.optDouble(i);
                switch (i % 4) {
                    case 0: {
                        positions[colorIndex] = (float)value;
                        continue block6;
                    }
                    case 1: {
                        r = (int)(value * 255.0);
                        continue block6;
                    }
                    case 2: {
                        g = (int)(value * 255.0);
                        continue block6;
                    }
                    case 3: {
                        int b = (int)(value * 255.0);
                        colors[colorIndex] = Color.argb((int)255, (int)r, (int)g, (int)b);
                    }
                }
            }
            return gradientColor;
        }
    }

    static final class Factory {
        private Factory() {
        }

        static AnimatableGradientColorValue newInstance(JSONObject json, LottieComposition composition) {
            AnimatableValueParser.Result<GradientColor> result = AnimatableValueParser.newInstance(json, 1.0f, composition, ValueFactory.INSTANCE).parseJson();
            GradientColor initialValue = (GradientColor)result.initialValue;
            return new AnimatableGradientColorValue(result.keyframes, initialValue);
        }
    }
}

