/*
 * Decompiled with CFR 0.152.
 */
package com.airbnb.lottie;

import android.content.Context;
import android.graphics.Path;
import android.graphics.PointF;
import android.util.DisplayMetrics;
import android.view.WindowManager;
import java.io.Closeable;

final class Utils {
    private static PointF emptyPoint;
    private static DisplayMetrics displayMetrics;

    Utils() {
    }

    static PointF emptyPoint() {
        if (emptyPoint == null) {
            emptyPoint = new PointF();
        }
        return emptyPoint;
    }

    static Path createPath(PointF startPoint, PointF endPoint, PointF cp1, PointF cp2) {
        Path path = new Path();
        path.moveTo(startPoint.x, startPoint.y);
        if (cp1 != null && cp1.length() != 0.0f && cp2 != null && cp2.length() != 0.0f) {
            path.cubicTo(startPoint.x + cp1.x, startPoint.y + cp1.y, endPoint.x + cp2.x, endPoint.y + cp2.y, endPoint.x, endPoint.y);
        } else {
            path.lineTo(endPoint.x, endPoint.y);
        }
        return path;
    }

    static void closeQuietly(Closeable closeable) {
        if (closeable != null) {
            try {
                closeable.close();
            }
            catch (RuntimeException rethrown) {
                throw rethrown;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    static int getScreenWidth(Context context) {
        if (displayMetrics == null) {
            displayMetrics = new DisplayMetrics();
        }
        WindowManager wm = (WindowManager)context.getSystemService("window");
        wm.getDefaultDisplay().getMetrics(displayMetrics);
        return Utils.displayMetrics.widthPixels;
    }

    static int getScreenHeight(Context context) {
        if (displayMetrics == null) {
            displayMetrics = new DisplayMetrics();
        }
        WindowManager wm = (WindowManager)context.getSystemService("window");
        wm.getDefaultDisplay().getMetrics(displayMetrics);
        return Utils.displayMetrics.heightPixels;
    }
}

