/*
 * Decompiled with CFR 0.152.
 */
package com.airbnb.lottie;

import android.annotation.SuppressLint;
import android.graphics.Canvas;
import android.graphics.ColorFilter;
import android.graphics.DashPathEffect;
import android.graphics.Matrix;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.PathEffect;
import android.graphics.PathMeasure;
import android.graphics.RectF;
import android.graphics.drawable.Drawable;
import android.support.annotation.IntRange;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.airbnb.lottie.AnimatableLayer;
import com.airbnb.lottie.BaseKeyframeAnimation;
import com.airbnb.lottie.KeyframeAnimation;
import com.airbnb.lottie.ScaleXY;
import com.airbnb.lottie.ShapeStroke;
import java.util.List;

class ShapeLayer
extends AnimatableLayer {
    private final BaseKeyframeAnimation.AnimationListener<Path> pathChangedListener = new BaseKeyframeAnimation.AnimationListener<Path>(){

        @Override
        public void onValueChanged(Path value) {
            ShapeLayer.this.onPathChanged();
        }
    };
    private final BaseKeyframeAnimation.AnimationListener<Integer> alphaChangedListener = new BaseKeyframeAnimation.AnimationListener<Integer>(){

        @Override
        public void onValueChanged(Integer value) {
            ShapeLayer.this.invalidateSelf();
        }
    };
    private final BaseKeyframeAnimation.AnimationListener<Integer> colorChangedListener = new BaseKeyframeAnimation.AnimationListener<Integer>(){

        @Override
        public void onValueChanged(Integer value) {
            ShapeLayer.this.onColorChanged();
        }
    };
    private final BaseKeyframeAnimation.AnimationListener<Float> lineWidthChangedListener = new BaseKeyframeAnimation.AnimationListener<Float>(){

        @Override
        public void onValueChanged(Float value) {
            ShapeLayer.this.invalidateSelf();
        }
    };
    private final BaseKeyframeAnimation.AnimationListener<Float> dashPatternChangedListener = new BaseKeyframeAnimation.AnimationListener<Float>(){

        @Override
        public void onValueChanged(Float value) {
            ShapeLayer.this.onDashPatternChanged();
        }
    };
    private final BaseKeyframeAnimation.AnimationListener<Float> strokeChangedListener = new BaseKeyframeAnimation.AnimationListener<Float>(){

        @Override
        public void onValueChanged(Float value) {
            ShapeLayer.this.onPathPropertiesChanged();
        }
    };
    private final BaseKeyframeAnimation.AnimationListener<ScaleXY> scaleChangedListener = new BaseKeyframeAnimation.AnimationListener<ScaleXY>(){

        @Override
        public void onValueChanged(ScaleXY value) {
            ShapeLayer.this.onPathPropertiesChanged();
        }
    };
    private final Paint paint = new Paint(1){
        {
            this.setStyle(Paint.Style.FILL);
        }
    };
    private final Path tempPath = new Path();
    private final Path currentPath = new Path();
    private final Path extraTrimPath = new Path();
    private final PathMeasure pathMeasure = new PathMeasure();
    private float currentPathScaleX;
    private float currentPathScaleY;
    private float currentDrawableScale = 1.0f;
    private float currentPathStrokeStart;
    private float currentPathStrokeEnd = 100.0f;
    private float currentPathStrokeOffset = 0.0f;
    @Nullable
    private KeyframeAnimation<ScaleXY> scale;
    private final RectF tempRect = new RectF();
    private final Matrix scaleMatrix = new Matrix();
    private BaseKeyframeAnimation<?, Path> path;
    private BaseKeyframeAnimation<?, Integer> color;
    private BaseKeyframeAnimation<?, Float> lineWidth;
    @Nullable
    private BaseKeyframeAnimation<?, Float> strokeStart;
    @Nullable
    private BaseKeyframeAnimation<?, Float> strokeEnd;
    @Nullable
    private BaseKeyframeAnimation<?, Float> strokeOffset;
    private BaseKeyframeAnimation<?, Integer> shapeOpacity;
    private BaseKeyframeAnimation<?, Integer> transformOpacity;
    private List<BaseKeyframeAnimation<?, Float>> lineDashPattern;
    private BaseKeyframeAnimation<?, Float> lineDashPatternOffset;
    private boolean pathPropertiesChanged = true;
    private boolean dashPatternChanged;

    ShapeLayer(Drawable.Callback callback) {
        super(callback);
    }

    void setIsStroke() {
        this.paint.setStyle(Paint.Style.STROKE);
        this.invalidateSelf();
    }

    public void setColor(KeyframeAnimation<Integer> color) {
        if (this.color != null) {
            this.removeAnimation(this.color);
            this.color.removeUpdateListener(this.colorChangedListener);
        }
        this.color = color;
        this.addAnimation(color);
        color.addUpdateListener(this.colorChangedListener);
        this.onColorChanged();
    }

    private void onColorChanged() {
        this.paint.setColor(this.color.getValue().intValue());
        this.invalidateSelf();
    }

    public void setPath(BaseKeyframeAnimation<?, Path> path) {
        if (this.path != null) {
            this.removeAnimation(this.path);
            this.path.removeUpdateListener(this.pathChangedListener);
        }
        this.path = path;
        this.addAnimation(path);
        path.addUpdateListener(this.pathChangedListener);
        this.onPathChanged();
    }

    void onPathChanged() {
        this.currentPath.reset();
        this.currentPath.set(this.path.getValue());
        this.currentPathStrokeStart = Float.NaN;
        this.currentPathStrokeEnd = Float.NaN;
        this.currentPathScaleX = Float.NaN;
        this.currentPathScaleY = Float.NaN;
        this.currentDrawableScale = 1.0f;
        this.onPathPropertiesChanged();
        this.invalidateSelf();
    }

    private void onPathPropertiesChanged() {
        this.pathPropertiesChanged = true;
        this.invalidateSelf();
    }

    @Override
    @SuppressLint(value={"NewApi"})
    public void draw(@NonNull Canvas canvas) {
        float scale = this.getLottieDrawable().getScale();
        if (this.currentDrawableScale != scale) {
            this.updateShape();
        }
        if (this.pathPropertiesChanged) {
            this.updateShape();
        }
        if (this.dashPatternChanged) {
            this.updateDashPattern();
        }
        if (this.lineWidth != null) {
            this.paint.setStrokeWidth(this.lineWidth.getValue().floatValue() * this.getLottieDrawable().getScale());
        }
        if (this.paint.getStyle() == Paint.Style.STROKE && this.paint.getStrokeWidth() == 0.0f) {
            return;
        }
        this.paint.setAlpha(this.getAlpha());
        canvas.drawPath(this.currentPath, this.paint);
        if (!this.extraTrimPath.isEmpty()) {
            canvas.drawPath(this.extraTrimPath, this.paint);
        }
    }

    private void updateShape() {
        boolean needsDrawableScale;
        this.pathPropertiesChanged = false;
        boolean needsStrokeStart = this.strokeStart != null && this.strokeStart.getValue().floatValue() != this.currentPathStrokeStart;
        boolean needsStrokeEnd = this.strokeEnd != null && this.strokeEnd.getValue().floatValue() != this.currentPathStrokeEnd;
        boolean needsStrokeOffset = this.strokeOffset != null && this.strokeOffset.getValue().floatValue() != this.currentPathStrokeOffset;
        boolean needsScaleX = this.scale != null && ((ScaleXY)this.scale.getValue()).getScaleX() != this.currentPathScaleX;
        boolean needsScaleY = this.scale != null && ((ScaleXY)this.scale.getValue()).getScaleY() != this.currentPathScaleY;
        boolean bl = needsDrawableScale = this.currentDrawableScale != this.getLottieDrawable().getScale();
        if (!(needsStrokeStart || needsStrokeEnd || needsScaleX || needsScaleY || needsStrokeOffset || needsDrawableScale)) {
            return;
        }
        this.currentPath.set(this.path.getValue());
        this.currentPath.computeBounds(this.tempRect, false);
        this.currentPathScaleX = this.scale == null ? 1.0f : ((ScaleXY)this.scale.getValue()).getScaleX();
        this.currentPathScaleY = this.scale == null ? 1.0f : ((ScaleXY)this.scale.getValue()).getScaleY();
        this.currentDrawableScale = this.getLottieDrawable().getScale();
        this.scaleMatrix.reset();
        this.scaleMatrix.setScale(this.currentPathScaleX, this.currentPathScaleY, this.tempRect.centerX(), this.tempRect.centerY());
        this.currentPath.transform(this.scaleMatrix, this.currentPath);
        this.scaleMatrix.reset();
        this.scaleMatrix.setScale(this.currentDrawableScale, this.currentDrawableScale, 0.0f, 0.0f);
        this.currentPath.transform(this.scaleMatrix, this.currentPath);
        if (needsStrokeStart || needsStrokeEnd || needsStrokeOffset) {
            this.tempPath.set(this.currentPath);
            this.pathMeasure.setPath(this.tempPath, false);
            this.currentPathStrokeStart = this.strokeStart.getValue().floatValue();
            this.currentPathStrokeEnd = this.strokeEnd.getValue().floatValue();
            float length = this.pathMeasure.getLength();
            float start = length * this.currentPathStrokeStart / 100.0f;
            float end = length * this.currentPathStrokeEnd / 100.0f;
            float newStart = Math.min(start, end);
            float newEnd = Math.max(start, end);
            this.currentPath.reset();
            this.currentPathStrokeOffset = this.strokeOffset.getValue().floatValue() / 360.0f * length;
            newStart += this.currentPathStrokeOffset;
            newEnd += this.currentPathStrokeOffset;
            if (newStart > length && newEnd > length) {
                newStart %= length;
                newEnd %= length;
            }
            if (newStart > newEnd) {
                newStart -= length;
            }
            this.pathMeasure.getSegment(newStart, newEnd, this.currentPath, true);
            this.extraTrimPath.reset();
            if (newEnd > length) {
                this.pathMeasure.getSegment(0.0f, newEnd % length, this.extraTrimPath, true);
            } else if (newStart < 0.0f) {
                this.pathMeasure.getSegment(length + newStart, length, this.extraTrimPath, true);
            }
        }
    }

    private void updateDashPattern() {
        float scale = this.getLottieDrawable().getScale();
        float[] values = new float[this.lineDashPattern.size()];
        int i = 0;
        while (i < this.lineDashPattern.size()) {
            values[i] = this.lineDashPattern.get(i).getValue().floatValue();
            if (i % 2 == 0) {
                if (values[i] < 1.0f) {
                    values[i] = 1.0f;
                }
            } else if (values[i] < 0.1f) {
                values[i] = 0.1f;
            }
            int n = i++;
            values[n] = values[n] * scale;
        }
        this.paint.setPathEffect((PathEffect)new DashPathEffect(values, this.lineDashPatternOffset.getValue().floatValue()));
    }

    @Override
    public int getAlpha() {
        int shapeOpacity = this.shapeOpacity == null ? 255 : this.shapeOpacity.getValue();
        int transformOpacity = this.transformOpacity == null ? 255 : this.transformOpacity.getValue();
        int layerOpacity = super.getAlpha();
        return (int)((float)shapeOpacity / 255.0f * (float)transformOpacity / 255.0f * (float)layerOpacity / 255.0f * 255.0f);
    }

    void setShapeOpacity(KeyframeAnimation<Integer> shapeOpacity) {
        if (this.shapeOpacity != null) {
            this.removeAnimation(this.shapeOpacity);
            this.shapeOpacity.removeUpdateListener(this.alphaChangedListener);
        }
        this.shapeOpacity = shapeOpacity;
        this.addAnimation(shapeOpacity);
        shapeOpacity.addUpdateListener(this.alphaChangedListener);
        this.invalidateSelf();
    }

    void setTransformOpacity(KeyframeAnimation<Integer> transformOpacity) {
        this.transformOpacity = transformOpacity;
        this.addAnimation(transformOpacity);
        transformOpacity.addUpdateListener(this.alphaChangedListener);
        this.invalidateSelf();
    }

    @Override
    public void setAlpha(@IntRange(from=0L, to=255L) int alpha) {
        this.paint.setAlpha(alpha);
        this.invalidateSelf();
    }

    @Override
    public void setColorFilter(ColorFilter colorFilter) {
    }

    @Override
    public int getOpacity() {
        return -3;
    }

    void setLineWidth(KeyframeAnimation<Float> lineWidth) {
        if (this.lineWidth != null) {
            this.removeAnimation(this.lineWidth);
            this.lineWidth.removeUpdateListener(this.lineWidthChangedListener);
        }
        this.lineWidth = lineWidth;
        this.addAnimation(lineWidth);
        lineWidth.addUpdateListener(this.lineWidthChangedListener);
        this.invalidateSelf();
    }

    void setDashPattern(List<BaseKeyframeAnimation<?, Float>> lineDashPattern, BaseKeyframeAnimation<?, Float> offset) {
        if (this.lineDashPattern != null) {
            this.removeAnimation(this.lineDashPattern.get(0));
            this.lineDashPattern.get(0).removeUpdateListener(this.dashPatternChangedListener);
            this.removeAnimation(this.lineDashPattern.get(1));
            this.lineDashPattern.get(1).removeUpdateListener(this.dashPatternChangedListener);
        }
        if (this.lineDashPatternOffset != null) {
            this.removeAnimation(this.lineDashPatternOffset);
            this.lineDashPatternOffset.removeUpdateListener(this.dashPatternChangedListener);
        }
        if (lineDashPattern.isEmpty()) {
            return;
        }
        this.lineDashPattern = lineDashPattern;
        this.lineDashPatternOffset = offset;
        for (int i = 0; i < lineDashPattern.size(); ++i) {
            BaseKeyframeAnimation<?, Float> dashPattern = lineDashPattern.get(i);
            this.addAnimation(dashPattern);
            dashPattern.addUpdateListener(this.dashPatternChangedListener);
        }
        this.addAnimation(offset);
        offset.addUpdateListener(this.dashPatternChangedListener);
        this.onDashPatternChanged();
    }

    private void onDashPatternChanged() {
        this.dashPatternChanged = true;
        this.invalidateSelf();
    }

    void setLineCapType(ShapeStroke.LineCapType lineCapType) {
        switch (lineCapType) {
            case Round: {
                this.paint.setStrokeCap(Paint.Cap.ROUND);
                break;
            }
            default: {
                this.paint.setStrokeCap(Paint.Cap.BUTT);
            }
        }
        this.invalidateSelf();
    }

    void setLineJoinType(ShapeStroke.LineJoinType lineJoinType) {
        switch (lineJoinType) {
            case Bevel: {
                this.paint.setStrokeJoin(Paint.Join.BEVEL);
                break;
            }
            case Miter: {
                this.paint.setStrokeJoin(Paint.Join.MITER);
                break;
            }
            case Round: {
                this.paint.setStrokeJoin(Paint.Join.ROUND);
            }
        }
    }

    void setTrimPath(KeyframeAnimation<Float> strokeStart, KeyframeAnimation<Float> strokeEnd, KeyframeAnimation<Float> strokeOffset) {
        if (this.strokeStart != null) {
            this.removeAnimation(this.strokeStart);
            this.strokeStart.removeUpdateListener(this.strokeChangedListener);
        }
        if (this.strokeEnd != null) {
            this.removeAnimation(this.strokeEnd);
            this.strokeEnd.removeUpdateListener(this.strokeChangedListener);
        }
        if (this.strokeOffset != null) {
            this.removeAnimation(this.strokeOffset);
            this.strokeOffset.removeUpdateListener(this.strokeChangedListener);
        }
        this.strokeStart = strokeStart;
        this.strokeEnd = strokeEnd;
        this.strokeOffset = strokeOffset;
        this.addAnimation(strokeStart);
        strokeStart.addUpdateListener(this.strokeChangedListener);
        this.addAnimation(strokeEnd);
        strokeEnd.addUpdateListener(this.strokeChangedListener);
        this.addAnimation(strokeOffset);
        strokeOffset.addUpdateListener(this.strokeChangedListener);
        this.onPathPropertiesChanged();
    }

    void setScale(KeyframeAnimation<ScaleXY> scale) {
        if (this.scale != null) {
            this.removeAnimation(this.scale);
            this.scale.removeUpdateListener(this.scaleChangedListener);
        }
        this.scale = scale;
        this.addAnimation(scale);
        scale.addUpdateListener(this.scaleChangedListener);
        this.onPathPropertiesChanged();
    }
}

