/*
 * Decompiled with CFR 0.152.
 */
package com.airbnb.lottie;

import com.airbnb.lottie.AnimatableFloatValue;
import com.airbnb.lottie.AnimatablePathValue;
import com.airbnb.lottie.AnimatablePointValue;
import com.airbnb.lottie.IAnimatablePathValue;
import com.airbnb.lottie.LottieComposition;
import org.json.JSONObject;

class RectangleShape {
    private final IAnimatablePathValue position;
    private final AnimatablePointValue size;
    private final AnimatableFloatValue cornerRadius;

    private RectangleShape(IAnimatablePathValue position, AnimatablePointValue size, AnimatableFloatValue cornerRadius) {
        this.position = position;
        this.size = size;
        this.cornerRadius = cornerRadius;
    }

    AnimatableFloatValue getCornerRadius() {
        return this.cornerRadius;
    }

    AnimatablePointValue getSize() {
        return this.size;
    }

    IAnimatablePathValue getPosition() {
        return this.position;
    }

    public String toString() {
        return "RectangleShape{cornerRadius=" + this.cornerRadius.getInitialValue() + ", position=" + this.position + ", size=" + this.size + '}';
    }

    static class Factory {
        private Factory() {
        }

        static RectangleShape newInstance(JSONObject json, LottieComposition composition) {
            return new RectangleShape(AnimatablePathValue.createAnimatablePathOrSplitDimensionPath(json.optJSONObject("p"), composition), AnimatablePointValue.Factory.newInstance(json.optJSONObject("s"), composition), AnimatableFloatValue.Factory.newInstance(json.optJSONObject("r"), composition));
        }
    }
}

